/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils.dao.yaml;

import de.derfrzocker.custom.ore.generator.utils.Config;
import de.derfrzocker.custom.ore.generator.utils.ReloadAble;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlDao<V>
implements ReloadAble {
    private File file;
    private YamlConfiguration yaml;

    public YamlDao(File file) {
        this.file = file;
    }

    public void init() {
        this.reload();
    }

    @Override
    public void reload() {
        this.yaml = new Config(this.file);
        try {
            this.yaml.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error while save YamlConfiguration to disk, file: " + this.file, e);
        }
    }

    public Optional<V> getFromStringKey(String key) {
        Object object = this.getYaml().get(key);
        if (object == null) {
            return Optional.empty();
        }
        return Optional.of(object);
    }

    public void saveFromStringKey(String key, V value) {
        this.getYaml().set(key, value);
        try {
            this.getYaml().save(this.getFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error while save data to disk, file: " + this.file + ", key: " + key + ", value: " + value, e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public YamlConfiguration getYaml() {
        return this.yaml;
    }
}

