/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils.command;

import de.derfrzocker.custom.ore.generator.utils.command.CommandSeparator;
import de.derfrzocker.custom.ore.generator.utils.command.HelpConfig;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HelpCommand
implements TabExecutor {
    @NotNull
    private final CommandSeparator commandSeparator;
    @NotNull
    private final HelpConfig helpConfig;

    public HelpCommand(@NotNull CommandSeparator commandSeparator, @NotNull HelpConfig helpConfig) {
        Validate.notNull((Object)commandSeparator, (String)"CommandSeparator can't be null");
        Validate.notNull((Object)helpConfig, (String)"HelpConfig can't be null");
        this.commandSeparator = commandSeparator;
        this.helpConfig = helpConfig;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length != 1) {
            this.sendShortHelp(sender);
            return true;
        }
        String commandName = args[0].toLowerCase();
        CommandSeparator.Command2 command2 = this.commandSeparator.getCommands().get(commandName);
        if (command2 == null) {
            this.sendShortHelp(sender);
            return true;
        }
        this.sendHelp(sender, commandName, command2);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, CommandSeparator.Command2> command2Entry : this.commandSeparator.getCommands().entrySet()) {
            String commandName = command2Entry.getKey();
            CommandSeparator.Command2 command2 = command2Entry.getValue();
            if (!commandName.startsWith(args[0])) continue;
            if (command2.getPermission() == null) {
                list.add(commandName);
                continue;
            }
            if (!command2.getPermission().hasPermission((Permissible)sender)) continue;
            list.add(commandName);
        }
        return list;
    }

    private void sendShortHelp(@NotNull CommandSender sender) {
        this.helpConfig.getHeaderMessageFormat().sendMessage(sender, new MessageValue[0]);
        boolean separator = false;
        for (Map.Entry<String, CommandSeparator.Command2> command2Entry : this.commandSeparator.getCommands().entrySet()) {
            String commandName = command2Entry.getKey();
            CommandSeparator.Command2 command2 = command2Entry.getValue();
            if (command2.getDescription() == null || command2.getPermission() == null) continue;
            if (separator) {
                this.helpConfig.getSeparatorMessageFormat().sendMessage(sender, new MessageValue[0]);
            }
            this.helpConfig.getShortHelpMessageFormat().sendMessage(sender, new MessageValue("command", commandName), new MessageValue("permission", command2.getPermission().getPermission()), new MessageValue("description", command2.getDescription().getRawMessage()));
            separator = true;
        }
        this.helpConfig.getFooterMessageFormat().sendMessage(sender, new MessageValue[0]);
    }

    private void sendHelp(@NotNull CommandSender sender, @NotNull String command, @NotNull CommandSeparator.Command2 command2) {
        if (command2.getUsage() != null) {
            this.helpConfig.getUsageMessageFormat().sendMessage(sender, new MessageValue("command", command), new MessageValue("usage", command2.getUsage().getRawMessage()));
        }
        if (command2.getPermission() != null) {
            this.helpConfig.getPermissionMessageFormat().sendMessage(sender, new MessageValue("command", command), new MessageValue("permission", command2.getPermission().getPermission()));
        }
        if (command2.getDescription() != null) {
            this.helpConfig.getDescriptionMessageFormat().sendMessage(sender, new MessageValue("command", command), new MessageValue("description", command2.getDescription().getRawMessage()));
        }
    }
}

