/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils.command;

import de.derfrzocker.custom.ore.generator.utils.command.CommandException;
import de.derfrzocker.custom.ore.generator.utils.command.WorldNotFoundException;
import de.derfrzocker.custom.ore.generator.utils.message.MessageKey;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandUtil {
    private CommandUtil() {
    }

    public static void runAsynchronously(@NotNull CommandSender commandSender, @NotNull Plugin plugin, @NotNull Runnable runnable) {
        Validate.notNull((Object)commandSender, (String)"CommandSender can't be null");
        Validate.notNull((Object)plugin, (String)"Plugin can't be null");
        Validate.notNull((Object)runnable, (String)"Runnable can't be null");
        Bukkit.getScheduler().runTaskAsynchronously(plugin, () -> {
            try {
                runnable.run();
            }
            catch (CommandException commandException) {
            }
            catch (Exception e) {
                commandSender.sendMessage("\u00a74Error while execute command, see console for more information.");
                commandSender.sendMessage("\u00a74Please report the error to the Developer.");
                e.printStackTrace();
            }
        });
    }

    @NotNull
    public static World getWorld(@NotNull String worldName, @Nullable MessageKey messageKey, @Nullable CommandSender commandSender) {
        Validate.notNull((Object)worldName, (String)"World name can't be null");
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            if (messageKey != null && commandSender != null) {
                messageKey.sendMessage(commandSender, new MessageValue("world", worldName));
            }
            throw new WorldNotFoundException(worldName, "The world '" + worldName + "' does not exists!");
        }
        return world;
    }
}

