/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils.command;

import de.derfrzocker.custom.ore.generator.utils.Permission;
import de.derfrzocker.custom.ore.generator.utils.message.MessageKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommandSeparator
implements TabExecutor {
    @NotNull
    private final Plugin plugin;
    @Nullable
    private Command2 fallBack;
    @NotNull
    private final Map<String, Command2> map = new HashMap<String, Command2>();

    public CommandSeparator(@NotNull Plugin plugin) {
        Validate.notNull((Object)plugin, (String)"Plugin can't be null");
        this.plugin = plugin;
    }

    public void registerExecutor(@NotNull TabExecutor executor, @Nullable String key, @Nullable Permission permission, @Nullable MessageKey usage, @Nullable MessageKey description) {
        Validate.notNull((Object)executor, (String)"TabExecutor can't be null");
        if (key == null) {
            this.fallBack = new Command2(executor, permission, usage, description);
            return;
        }
        this.map.put(key.toLowerCase(), new Command2(executor, permission, usage, description));
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Command2 command2;
        Validate.notNull((Object)sender, (String)"CommandSender can't be null");
        Validate.notNull((Object)command, (String)"Command can't be null");
        Validate.notNull((Object)label, (String)"Label can't be null");
        Validate.notNull((Object)args, (String)"Arguments can't be null");
        if (args.length == 0) {
            Command2 command22;
            if (this.map.containsKey("") && ((command22 = this.map.get("")).getPermission() == null || command22.getPermission().hasPermission((Permissible)sender)) && command22.getTabExecutor().onCommand(sender, command, label, args)) {
                return true;
            }
            if (this.fallBack == null) {
                return false;
            }
            if (this.fallBack.getPermission() == null || this.fallBack.getPermission().hasPermission((Permissible)sender)) {
                return this.fallBack.getTabExecutor().onCommand(sender, command, label, args);
            }
            return false;
        }
        if (this.map.containsKey(args[0].toLowerCase()) && ((command2 = this.map.get(args[0].toLowerCase())).getPermission() == null || command2.getPermission().hasPermission((Permissible)sender)) && command2.getTabExecutor().onCommand(sender, command, label, this.buildStrings(args))) {
            return true;
        }
        if (this.fallBack == null) {
            return false;
        }
        if (this.fallBack.getPermission() == null || this.fallBack.getPermission().hasPermission((Permissible)sender)) {
            return this.fallBack.getTabExecutor().onCommand(sender, command, label, args);
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        Command2 command2;
        Validate.notNull((Object)sender, (String)"CommandSender can't be null");
        Validate.notNull((Object)command, (String)"Command can't be null");
        Validate.notNull((Object)alias, (String)"Alias can't be null");
        Validate.notNull((Object)args, (String)"Arguments can't be null");
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            this.map.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(args[0].toLowerCase())).filter(entry -> ((Command2)entry.getValue()).getPermission() == null || ((Command2)entry.getValue()).getPermission().hasPermission((Permissible)sender)).forEach(entry -> list.add((String)entry.getKey()));
            return list;
        }
        if (args.length >= 2 && this.map.containsKey(args[0]) && ((command2 = this.map.get(args[0].toLowerCase())).getPermission() == null || command2.getPermission().hasPermission((Permissible)sender))) {
            return command2.getTabExecutor().onTabComplete(sender, command, alias, this.buildStrings(args));
        }
        return list;
    }

    @NotNull
    Map<String, Command2> getCommands() {
        return this.map;
    }

    private String[] buildStrings(String[] args) {
        String[] strings = new String[args.length - 1];
        if (args.length - 1 > 0) {
            System.arraycopy(args, 1, strings, 0, args.length - 1);
        }
        return strings;
    }

    final class Command2 {
        @NotNull
        private final TabExecutor tabExecutor;
        @Nullable
        private final Permission permission;
        @Nullable
        private final MessageKey usage;
        @Nullable
        private final MessageKey description;

        private Command2(@Nullable TabExecutor tabExecutor, @Nullable Permission permission, @Nullable MessageKey usage, MessageKey description) {
            Validate.notNull((Object)tabExecutor, (String)"TabExecutor can't be null");
            this.tabExecutor = tabExecutor;
            this.permission = permission;
            this.usage = usage;
            this.description = description;
        }

        @NotNull
        TabExecutor getTabExecutor() {
            return this.tabExecutor;
        }

        @Nullable
        Permission getPermission() {
            return this.permission;
        }

        @Nullable
        MessageKey getUsage() {
            return this.usage;
        }

        @Nullable
        MessageKey getDescription() {
            return this.description;
        }
    }
}

