/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils;

import org.apache.commons.lang.Validate;
import org.bukkit.Server;
import org.jetbrains.annotations.NotNull;

public enum Version implements Comparable<Version>
{
    v1_19_R3(20),
    v1_19_R2(19),
    v1_19_R1(18),
    v1_18_R2(17),
    v1_18_R1(16),
    v1_17_R1(15),
    v1_16_R3(14),
    v1_16_R2(13),
    v1_16_R1(12),
    v1_15_R1(11),
    v1_14_R1(10),
    v1_13_R2(9),
    v1_13_R1(8),
    v1_12_R1(7),
    v1_11_R1(6),
    v1_10_R1(5),
    v1_9_R2(4),
    v1_9_R1(3),
    v1_8_R3(2),
    v1_8_R2(1),
    v1_8_R1(0),
    UNKNOWN(-1);

    private final int value;

    private Version(int value) {
        this.value = value;
    }

    @NotNull
    public static Version getServerVersion(@NotNull Server server) {
        Validate.notNull((Object)server, (String)"Server cannot be null");
        String packageName = server.getClass().getPackage().getName();
        String version = packageName.substring(packageName.lastIndexOf(46) + 1);
        try {
            return Version.valueOf(version.trim());
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }

    public static boolean isPaper(@NotNull Server server) {
        Validate.notNull((Object)server, (String)"Server cannot be null");
        return server.getName().equalsIgnoreCase("Paper");
    }

    public boolean isNewerThan(@NotNull Version version) {
        Validate.notNull((Object)version, (String)"Version cannot be null");
        Validate.isTrue((this != UNKNOWN ? 1 : 0) != 0, (String)"Cannot check, if version UNKNOWN is newer");
        Validate.isTrue((version != UNKNOWN ? 1 : 0) != 0, (String)"Cannot check, if version UNKNOWN is newer");
        return this.value > version.value;
    }

    public boolean isNewerOrSameThan(@NotNull Version version) {
        Validate.notNull((Object)version, (String)"Version cannot be null");
        Validate.isTrue((this != UNKNOWN ? 1 : 0) != 0, (String)"Cannot check, if version UNKNOWN is newer or same");
        Validate.isTrue((version != UNKNOWN ? 1 : 0) != 0, (String)"Cannot check, if version UNKNOWN is newer or same");
        return this.value >= version.value;
    }

    public boolean isOlderThan(@NotNull Version version) {
        Validate.notNull((Object)version, (String)"Version cannot be null");
        Validate.isTrue((this != UNKNOWN ? 1 : 0) != 0, (String)"Cannot check, if version UNKNOWN is older");
        Validate.isTrue((version != UNKNOWN ? 1 : 0) != 0, (String)"Cannot check, if version UNKNOWN is older");
        return this.value < version.value;
    }

    public boolean isOlderOrSameThan(@NotNull Version version) {
        Validate.notNull((Object)version, (String)"Version cannot be null");
        Validate.isTrue((this != UNKNOWN ? 1 : 0) != 0, (String)"Cannot check, if version UNKNOWN is older or same");
        Validate.isTrue((version != UNKNOWN ? 1 : 0) != 0, (String)"Cannot check, if version UNKNOWN is older or same");
        return this.value <= version.value;
    }
}

