/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils;

import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.utils.Version;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class RegisterUtil {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final CustomOreGeneratorService service;
    @NotNull
    private final Version currentVersion;
    private final boolean paper;

    public RegisterUtil(@NotNull Plugin plugin, @NotNull CustomOreGeneratorService service, @NotNull Version currentVersion, boolean paper) {
        Validate.notNull((Object)plugin, (String)"Plugin can not be null");
        Validate.notNull((Object)service, (String)"CustomOreGeneratorService can not be null");
        Validate.notNull((Object)currentVersion, (String)"Version can not be null");
        this.plugin = plugin;
        this.service = service;
        this.currentVersion = currentVersion;
        this.paper = paper;
    }

    public void register(@NotNull OreGenerator oreGenerator) {
        this.service.registerOreGenerator(oreGenerator);
    }

    public void register(@NotNull OreGenerator oreGenerator, boolean defaultOreGenerator) {
        this.register(oreGenerator);
        if (defaultOreGenerator) {
            this.service.setDefaultOreGenerator(oreGenerator);
        }
    }

    public void register(@NotNull Version minimalVersion, @NotNull Version maximumVersion, @NotNull OreGeneratorSupplier oreGenerator, boolean defaultOreGenerator) {
        if (this.currentVersion.isNewerOrSameThan(minimalVersion) && this.currentVersion.isOlderOrSameThan(maximumVersion)) {
            this.register(oreGenerator.get(), defaultOreGenerator);
        }
    }

    public void register(@NotNull Version minimalVersion, @NotNull Version maximumVersion, boolean paper, @NotNull OreGeneratorSupplier oreGenerator, boolean defaultOreGenerator) {
        if (this.currentVersion.isNewerOrSameThan(minimalVersion) && this.currentVersion.isOlderOrSameThan(maximumVersion) && paper && this.paper) {
            this.register(oreGenerator.get(), defaultOreGenerator);
        }
    }

    public void register(@NotNull BlockSelector blockSelector) {
        this.service.registerBlockSelector(blockSelector);
    }

    public void register(@NotNull BlockSelector blockSelector, boolean defaultBlockSelector) {
        this.register(blockSelector);
        if (defaultBlockSelector) {
            this.service.setDefaultBlockSelector(blockSelector);
        }
    }

    public void register(@NotNull CustomData customData) {
        this.service.registerCustomData(customData);
    }

    public void register(@NotNull Version minimalVersion, @NotNull CustomDataSupplier customData) {
        if (this.currentVersion.isNewerOrSameThan(minimalVersion)) {
            this.register(customData.get());
        }
    }

    public void register(@NotNull Version minimalVersion, @NotNull String pluginName, @NotNull CustomDataSupplier customData) {
        if (this.currentVersion.isNewerOrSameThan(minimalVersion) && this.plugin.getServer().getPluginManager().getPlugin(pluginName) != null) {
            this.register(customData.get());
        }
    }

    public void register(@NotNull Version minimalVersion, @NotNull Version maximumVersion, @NotNull CustomDataSupplier customData) {
        if (this.currentVersion.isNewerOrSameThan(minimalVersion) && this.currentVersion.isOlderOrSameThan(maximumVersion)) {
            this.register(customData.get());
        }
    }

    @FunctionalInterface
    public static interface OreGeneratorSupplier {
        public OreGenerator get();
    }

    @FunctionalInterface
    public static interface CustomDataSupplier {
        public CustomData get();
    }
}

