/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class Permission {
    private static final Map<Plugin, Set<Permission>> PERMISSIONS = new HashMap<Plugin, Set<Permission>>();
    private final Permission parent;
    private final String permission;
    private final Plugin plugin;
    private final boolean commandPermission;

    public Permission(Permission parent, String permission, Plugin plugin, boolean commandPermission) {
        this.parent = parent;
        this.permission = permission;
        this.plugin = plugin;
        this.commandPermission = commandPermission;
        PERMISSIONS.computeIfAbsent(plugin, plugin1 -> new HashSet()).add(this);
    }

    public String getPermission() {
        if (this.parent == null) {
            return this.permission;
        }
        return String.format("%s.%s", this.parent.getPermission(), this.permission);
    }

    public static boolean hasAnyCommandPermission(Plugin plugin, Permissible permissible) {
        return PERMISSIONS.computeIfAbsent(plugin, plugin1 -> new HashSet()).stream().filter(Permission::isCommandPermission).anyMatch(permission -> permissible.hasPermission(permission.getPermission()));
    }

    public boolean hasPermission(Permissible permissible) {
        return permissible.hasPermission(this.getPermission());
    }

    public boolean hasPermission(Permissible permissible, int level) {
        int max = this.getPermissionLevel(permissible);
        if (max == -1) {
            return true;
        }
        return max >= level;
    }

    public int getPermissionLevel(Permissible permissible) {
        if (permissible.isOp()) {
            return -1;
        }
        int max = 0;
        Set permissionAttachmentInfos = permissible.getEffectivePermissions();
        for (PermissionAttachmentInfo permissionAttachmentInfo : permissionAttachmentInfos) {
            String permission;
            if (!permissionAttachmentInfo.getValue() || !(permission = permissionAttachmentInfo.getPermission().toLowerCase()).startsWith(this.getPermission())) continue;
            if ((permission = permission.replace(this.getPermission(), "")).equalsIgnoreCase("*")) {
                return -1;
            }
            try {
                int amount = Integer.parseInt(permission);
                if (amount <= max) continue;
                max = amount;
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Unexpected value in permission, expect a Number or '*' but got '" + permission + "'");
                this.plugin.getLogger().warning("Please check your permission: '" + permissionAttachmentInfo.getPermission() + "'");
            }
        }
        return max;
    }

    public boolean isCommandPermission() {
        return this.commandPermission;
    }
}

