/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils;

import java.util.function.Supplier;
import java.util.stream.Stream;

public enum Language {
    ENGLISH(new String[]{"English"}, "lang/en.yml"),
    GERMAN(new String[]{"Deutsch"}, "lang/de.yml"),
    CHINESE(new String[]{"\u4e2d\u56fd", "\u4e2d\u570b"}, "lang/zh.yml"),
    CUSTOM(new String[]{"Custom"}, "messages.yml");

    private final String[] names;
    private final String fileLocation;
    private static Supplier<Language> languageSupplier;

    private Language(String[] strings, String s) {
        this.names = strings;
        this.fileLocation = s;
    }

    public static Language getLanguage(String name) {
        try {
            return Language.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Stream.of(Language.values()).filter(value -> Stream.of(value.getNames()).anyMatch(name2 -> name2.equalsIgnoreCase(name))).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }

    public static Language getDefaultLanguage() {
        if (languageSupplier == null) {
            return CUSTOM;
        }
        return languageSupplier.get();
    }

    public static void setDefaultLanguage(Supplier<Language> defaultLanguage) {
        languageSupplier = defaultLanguage;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public String[] getNames() {
        return this.names;
    }
}

