/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Config
extends YamlConfiguration {
    public Config(File file) {
        if (!file.exists()) {
            try {
                Files.createParentDirs((File)file);
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Error while create a new File: " + file, e);
            }
        }
        try {
            this.load(file);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while load data from file: " + file, e);
        }
    }

    public Config(InputStream input) {
        try {
            this.load(input);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while load data from InputStream: " + input, e);
        }
    }

    public Config(String input) {
        try {
            this.loadFromString(input);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException("Error while load data from String: " + input, e);
        }
    }

    public void save(File file) throws IOException {
        Files.createParentDirs((File)file);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);){
            writer.write(this.saveToString());
        }
    }

    public void load(File file) throws IOException, InvalidConfigurationException {
        this.load(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));
    }

    public void load(InputStream input) throws IOException, InvalidConfigurationException {
        this.load(new InputStreamReader(input, Charsets.UTF_8));
    }

    public static Config getConfig(@NotNull Plugin plugin, @NotNull String name) {
        return Config.getConfig(plugin, name, true);
    }

    public static Config getConfig(@NotNull Plugin plugin, @NotNull String name, boolean saveDefaults) {
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
        Validate.notNull((Object)name, (String)"Name cannot be null");
        if (!name.endsWith(".yml")) {
            name = String.format("%s.yml", name);
        }
        File file = new File(plugin.getDataFolder().getPath(), name);
        Config defaults = new Config(plugin.getResource(name));
        if (!file.exists()) {
            plugin.saveResource(name, true);
        }
        Config config = new Config(file);
        config.setDefaults((Configuration)defaults);
        if (saveDefaults) {
            config.options().copyDefaults(true);
            try {
                config.save(file);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while save data to file: " + file, e);
            }
        }
        return config;
    }
}

