/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_8_R3.customdata;

import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractVariantCustomData;
import java.util.Optional;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.IBlockData;
import net.minecraft.server.v1_8_R3.IBlockState;
import net.minecraft.server.v1_8_R3.World;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.util.CraftMagicNumbers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantApplier_v1_8_R3
implements AbstractVariantCustomData.VariantApplier {
    @NotNull
    private final CustomData customData;

    public VariantApplier_v1_8_R3(@NotNull CustomData data) {
        Validate.notNull((Object)data, (String)"CustomData can not be null");
        this.customData = data;
    }

    @Override
    public void apply(@NotNull OreConfig oreConfig, @NotNull Object location, @NotNull Object blockAccess) {
        BlockPosition blockPosition = (BlockPosition)location;
        World world = (World)blockAccess;
        IBlockData oldIBlockData = world.getType(blockPosition);
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            return;
        }
        IBlockData newIBlockData = oldIBlockData.getBlock().fromLegacyData(((Integer)objectOptional.get()).intValue());
        IBlockState<?> variant = this.getVariantBlockState(oreConfig.getMaterial());
        if (variant == null) {
            return;
        }
        world.setTypeAndData(blockPosition, oldIBlockData.set(variant, newIBlockData.get(variant)), 2);
    }

    @Override
    public boolean canApply(@NotNull OreConfig oreConfig) {
        return this.getVariantBlockState(oreConfig.getMaterial()) != null;
    }

    @Override
    public boolean isValidCustomData(@NotNull Integer customData, @NotNull OreConfig oreConfig) {
        IBlockState<?> variant = this.getVariantBlockState(oreConfig.getMaterial());
        if (variant == null) {
            return false;
        }
        return variant.c().size() > customData;
    }

    @Override
    public boolean hasCustomData(@NotNull BlockState blockState) {
        IBlockState<?> variant = this.getVariantBlockState(blockState.getType());
        if (variant == null) {
            return false;
        }
        IBlockData iBlockData = ((CraftWorld)blockState.getWorld()).getHandle().getType(new BlockPosition(blockState.getX(), blockState.getY(), blockState.getZ()));
        return iBlockData.getBlock().toLegacyData(iBlockData) != 0;
    }

    @Override
    public int getCustomData(@NotNull BlockState blockState) {
        IBlockData iBlockData = ((CraftWorld)blockState.getWorld()).getHandle().getType(new BlockPosition(blockState.getX(), blockState.getY(), blockState.getZ()));
        return iBlockData.getBlock().toLegacyData(iBlockData);
    }

    @Nullable
    private IBlockState<?> getVariantBlockState(@NotNull Material material) {
        IBlockState variant = null;
        for (IBlockState iBlockState : CraftMagicNumbers.getBlock((Material)material).P().d()) {
            if (!iBlockState.a().equals("variant")) continue;
            variant = iBlockState;
            break;
        }
        return variant;
    }
}

