/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_8_R3.customdata;

import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractNBTTagCustomData;
import java.util.Optional;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.MojangsonParseException;
import net.minecraft.server.v1_8_R3.MojangsonParser;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.TileEntity;
import net.minecraft.server.v1_8_R3.World;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.util.CraftMagicNumbers;
import org.jetbrains.annotations.NotNull;

public class NBTTagApplier_v1_8_R3
implements AbstractNBTTagCustomData.NBTTagApplier {
    @NotNull
    private final CustomData customData;

    public NBTTagApplier_v1_8_R3(@NotNull CustomData data) {
        Validate.notNull((Object)data, (String)"CustomData can not be null");
        this.customData = data;
    }

    @Override
    public void apply(@NotNull OreConfig oreConfig, @NotNull Object location, @NotNull Object blockAccess) {
        World world = (World)blockAccess;
        BlockPosition blockPosition = (BlockPosition)location;
        TileEntity tileEntity = world.getTileEntity(blockPosition);
        if (tileEntity == null) {
            return;
        }
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            return;
        }
        String nbtTag = (String)objectOptional.get();
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        tileEntity.b(nbtTagCompound);
        try {
            NBTTagCompound nbtTagCompound1 = MojangsonParser.parse((String)nbtTag);
            nbtTagCompound.a(nbtTagCompound1);
        }
        catch (MojangsonParseException e) {
            throw new RuntimeException("Error while parsing String to NBTTagCompound", e);
        }
        tileEntity.a(nbtTagCompound);
    }

    @Override
    public boolean isValidCustomData(@NotNull String customData, @NotNull OreConfig oreConfig) {
        try {
            MojangsonParser.parse((String)customData);
        }
        catch (MojangsonParseException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean canApply(@NotNull OreConfig oreConfig) {
        return CraftMagicNumbers.getBlock((Material)oreConfig.getMaterial()).isTileEntity();
    }

    @Override
    public boolean hasCustomData(@NotNull BlockState blockState) {
        TileEntity tileEntity = ((CraftWorld)blockState.getWorld()).getHandle().getTileEntity(new BlockPosition(blockState.getX(), blockState.getY(), blockState.getZ()));
        if (tileEntity == null) {
            return false;
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        tileEntity.b(nbtTagCompound);
        return nbtTagCompound.c().size() > 4;
    }

    @Override
    @NotNull
    public String getCustomData(@NotNull BlockState blockState) {
        TileEntity tileEntity = ((CraftWorld)blockState.getWorld()).getHandle().getTileEntity(new BlockPosition(blockState.getX(), blockState.getY(), blockState.getZ()));
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        tileEntity.b(nbtTagCompound);
        nbtTagCompound.remove("id");
        nbtTagCompound.remove("x");
        nbtTagCompound.remove("y");
        nbtTagCompound.remove("z");
        return nbtTagCompound.toString();
    }
}

