/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_8_R3;

import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.api.WorldConfig;
import de.derfrzocker.custom.ore.generator.api.WorldHandler;
import de.derfrzocker.custom.ore.generator.impl.v1_8_R3.ChunkAccessImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.IBlockData;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.util.CraftMagicNumbers;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CustomOreBlockPopulator_v1_8_R3
extends BlockPopulator
implements WorldHandler,
Listener {
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;

    public CustomOreBlockPopulator_v1_8_R3(@NotNull JavaPlugin javaPlugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier) {
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        this.serviceSupplier = serviceSupplier;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
    }

    public void populate(@NotNull World world, @NotNull Random random, @NotNull Chunk source) {
        Set<Biome> biomes = this.getBiomes(source);
        CustomOreGeneratorService service = this.serviceSupplier.get();
        Optional<WorldConfig> optional = service.getWorldConfig(world.getName());
        if (!optional.isPresent()) {
            return;
        }
        WorldConfig worldConfig = optional.get();
        biomes.forEach(biome -> {
            List<OreConfig> oreConfigs = Arrays.asList((OreConfig[])worldConfig.getOreConfigs().stream().filter(oreConfig -> oreConfig.getBiomes().contains(biome) || oreConfig.shouldGeneratedAll()).filter(OreConfig::isActivated).toArray(OreConfig[]::new));
            oreConfigs.forEach(oreConfig -> this.generate((OreConfig)oreConfig, (CraftWorld)world, source, (Biome)biome, service));
        });
    }

    private Set<Biome> getBiomes(Chunk chunk) {
        HashSet<Biome> set = new HashSet<Biome>();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                set.add(chunk.getBlock(x, 0, z).getBiome());
            }
        }
        return set;
    }

    private void generate(OreConfig oreConfig, CraftWorld craftWorld, Chunk chunk, Biome biome, CustomOreGeneratorService service) {
        Optional<OreGenerator> optionalOreGenerator = service.getOreGenerator(oreConfig.getOreGenerator());
        Optional<BlockSelector> optionalBlockSelector = service.getBlockSelector(oreConfig.getBlockSelector());
        if (!optionalOreGenerator.isPresent()) {
            return;
        }
        if (!optionalBlockSelector.isPresent()) {
            return;
        }
        OreGenerator oreGenerator = optionalOreGenerator.get();
        BlockSelector blockSelector = optionalBlockSelector.get();
        Random random = service.createRandom(craftWorld.getSeed() + (long)oreConfig.getMaterial().toString().hashCode() + (long)oreConfig.getName().hashCode(), chunk.getX(), chunk.getZ());
        Location chunkLocation = new Location(null, (double)(chunk.getX() << 4), 0.0, (double)(chunk.getZ() << 4));
        Set<Location> locations = blockSelector.selectBlocks((x, z) -> craftWorld.getHighestBlockYAt(chunkLocation.getBlockX() + x, chunkLocation.getBlockZ() + z), oreConfig, random);
        HashSet<Location> biomeLocations = new HashSet<Location>();
        Set<Material> selectMaterials = oreConfig.getSelectMaterials().isEmpty() ? oreConfig.getReplaceMaterials() : oreConfig.getSelectMaterials();
        locations.stream().filter(location -> this.checkBlockAndBiome(chunk, (Location)location, biome, selectMaterials)).forEach(biomeLocations::add);
        craftWorld.getHandle().captureTreeGeneration = true;
        craftWorld.getHandle().captureBlockStates = true;
        oreGenerator.generate(oreConfig, new ChunkAccessImpl(craftWorld.getHandle()), chunk.getX(), chunk.getZ(), random, biome, biomeLocations);
        craftWorld.getHandle().captureTreeGeneration = false;
        craftWorld.getHandle().captureBlockStates = false;
        IBlockData blockData = CraftMagicNumbers.getBlock((Material)oreConfig.getMaterial()).getBlockData();
        for (BlockState blockState : craftWorld.getHandle().capturedBlockStates) {
            BlockPosition blockPosition = new BlockPosition(blockState.getX(), blockState.getY(), blockState.getZ());
            if (!craftWorld.getHandle().setTypeAndData(blockPosition, blockData, 2)) continue;
            oreConfig.getCustomData().forEach((customData, object) -> customData.getCustomDataApplier().apply(oreConfig, blockPosition, craftWorld.getHandle()));
        }
        craftWorld.getHandle().capturedBlockStates.clear();
    }

    @EventHandler
    public void onWorldLoad(@NotNull WorldInitEvent event) {
        if (event.getWorld().getPopulators().contains(this)) {
            return;
        }
        event.getWorld().getPopulators().add(this);
    }

    private boolean checkBlockAndBiome(Chunk chunk, Location location, Biome biome, Set<Material> materials) {
        boolean isBiome;
        Block block = chunk.getBlock(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        boolean bl = isBiome = block.getBiome() == biome;
        if (!isBiome) {
            return false;
        }
        return materials.contains(block.getType());
    }
}

