/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_19_R2.customdata;

import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataApplier;
import dev.linwood.itemmods.ItemMods;
import dev.linwood.itemmods.pack.PackObject;
import dev.linwood.itemmods.pack.asset.BlockAsset;
import dev.linwood.itemmods.pack.asset.raw.ModelAsset;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_19_R2.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_19_R2.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_19_R2.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ItemModsApplier_v1_19_R2
implements CustomDataApplier {
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    @NotNull
    private final CustomData customData;

    public ItemModsApplier_v1_19_R2(@NotNull CustomData data) {
        Validate.notNull((Object)data, (String)"CustomData can not be null");
        this.customData = data;
    }

    @Override
    public void apply(@NotNull OreConfig oreConfig, @NotNull Object position, @NotNull Object blockAccess) {
        Location location = (Location)position;
        LimitedRegion limitedRegion = (LimitedRegion)blockAccess;
        BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        GeneratorAccessSeed generatorAccess = ((CraftLimitedRegion)limitedRegion).getHandle();
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            return;
        }
        String name = (String)objectOptional.get();
        PackObject packObject = new PackObject(name);
        BlockAsset blockAsset = packObject.getBlock();
        if (blockAsset == null) {
            return;
        }
        ModelAsset modelAsset = packObject.getModel();
        if (modelAsset == null) {
            return;
        }
        TileEntity tileEntity = generatorAccess.c_(blockPosition);
        if (tileEntity != null) {
            TileEntityMobSpawner spawnerBlock = (TileEntityMobSpawner)tileEntity;
            MobSpawnerAbstract spawner = spawnerBlock.d();
            spawner.n = 0;
            spawner.k = 0;
            EntityArmorStand armorStand = new EntityArmorStand(EntityTypes.d, null);
            Item item = (Item)BuiltInRegistries.i.a(new MinecraftKey(modelAsset.getFallbackTexture().getKey().toString()));
            ItemStack itemStack = new ItemStack((IMaterial)item);
            NBTTagCompound compoundTag = itemStack.v();
            compoundTag.a("CustomModelData", packObject.getCustomModel().intValue());
            armorStand.setItemSlot(EnumItemSlot.a, itemStack, true);
            NBTTagCompound saved = new NBTTagCompound();
            armorStand.e(saved);
            spawner.f = new MobSpawnerData(saved, Optional.empty());
            if (tileEntity.persistentDataContainer == null) {
                tileEntity.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
            }
            tileEntity.persistentDataContainer.set(new NamespacedKey((Plugin)ItemMods.getPlugin(), "custom_block_type"), PersistentDataType.STRING, (Object)packObject.toString());
            generatorAccess.B(blockPosition).d(blockPosition);
            generatorAccess.B(blockPosition).a(tileEntity);
        }
    }
}

