/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_19_R1.customdata;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractSkullTextureCustomData;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import org.bukkit.Location;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.generator.CraftLimitedRegion;
import org.bukkit.generator.LimitedRegion;
import org.jetbrains.annotations.NotNull;

public class SkullTextureApplier_v1_19_R1
implements AbstractSkullTextureCustomData.SkullTextureApplier {
    @NonNull
    private final CustomData customData;

    @Override
    public void apply(@NotNull OreConfig oreConfig, @NotNull Object position, @NotNull Object blockAccess) {
        Location location = (Location)position;
        LimitedRegion limitedRegion = (LimitedRegion)blockAccess;
        BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        GeneratorAccessSeed generatorAccess = ((CraftLimitedRegion)limitedRegion).getHandle();
        TileEntity tileEntity = generatorAccess.c_(blockPosition);
        if (tileEntity == null) {
            return;
        }
        if (!(tileEntity instanceof TileEntitySkull)) {
            return;
        }
        TileEntitySkull skull = (TileEntitySkull)tileEntity;
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            return;
        }
        String texture = (String)objectOptional.get();
        GameProfile gameProfile = new GameProfile(UUID.nameUUIDFromBytes(texture.getBytes()), null);
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
        skull.a(gameProfile);
        NBTTagCompound nbtTagCompound = skull.m();
        generatorAccess.B(blockPosition).d(blockPosition);
        generatorAccess.B(blockPosition).a(nbtTagCompound);
    }

    @Override
    public boolean hasCustomData(@NotNull Skull skull) {
        TileEntity tileEntity = ((CraftWorld)skull.getWorld()).getHandle().c_(new BlockPosition(skull.getX(), skull.getY(), skull.getZ()));
        if (tileEntity == null) {
            return false;
        }
        if (!(tileEntity instanceof TileEntitySkull)) {
            return false;
        }
        GameProfile gameProfile = ((TileEntitySkull)tileEntity).e;
        if (gameProfile == null) {
            return false;
        }
        Collection propertyCollection = gameProfile.getProperties().get((Object)"textures");
        if (propertyCollection == null || propertyCollection.isEmpty()) {
            return false;
        }
        for (Property property : propertyCollection) {
            if (!property.getName().equals("textures")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCustomData(@NotNull Skull skull) {
        TileEntitySkull tileEntitySkull = (TileEntitySkull)((CraftWorld)skull.getWorld()).getHandle().c_(new BlockPosition(skull.getX(), skull.getY(), skull.getZ()));
        GameProfile gameProfile = tileEntitySkull.e;
        for (Property property : gameProfile.getProperties().get((Object)"textures")) {
            if (!property.getName().equals("textures")) continue;
            return property.getValue();
        }
        throw new RuntimeException("TileEntitySkull on Location " + tileEntitySkull.p() + " dont have the property 'textures' in its GameProfile " + gameProfile);
    }

    public SkullTextureApplier_v1_19_R1(@NonNull CustomData customData) {
        if (customData == null) {
            throw new NullPointerException("customData is marked non-null but is null");
        }
        this.customData = customData;
    }
}

