/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_18_R2.customdata;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractNBTTagCustomData;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.entity.TileEntity;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.generator.LimitedRegion;
import org.jetbrains.annotations.NotNull;

public class NBTTagApplier_v1_18_R2
implements AbstractNBTTagCustomData.NBTTagApplier {
    @NotNull
    private final CustomData customData;

    public NBTTagApplier_v1_18_R2(@NotNull CustomData data) {
        Validate.notNull((Object)data, (String)"CustomData can not be null");
        this.customData = data;
    }

    @Override
    public void apply(@NotNull OreConfig oreConfig, @NotNull Object position, @NotNull Object blockAccess) {
        Location location = (Location)position;
        LimitedRegion limitedRegion = (LimitedRegion)blockAccess;
        BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        GeneratorAccessSeed generatorAccess = ((CraftLimitedRegion)limitedRegion).getHandle();
        TileEntity tileEntity = generatorAccess.c_(blockPosition);
        if (tileEntity == null) {
            return;
        }
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            return;
        }
        String nbtTag = (String)objectOptional.get();
        NBTTagCompound nbtTagCompound = tileEntity.m();
        try {
            NBTTagCompound nbtTagCompound1 = MojangsonParser.a((String)nbtTag);
            nbtTagCompound.a(nbtTagCompound1);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException("Error while parsing String to NBTTagCompound", e);
        }
        tileEntity.a(nbtTagCompound);
        generatorAccess.z(blockPosition).d(blockPosition);
        generatorAccess.z(blockPosition).a(tileEntity);
    }

    @Override
    public boolean isValidCustomData(@NotNull String customData, @NotNull OreConfig oreConfig) {
        try {
            MojangsonParser.a((String)customData);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean canApply(@NotNull OreConfig oreConfig) {
        return CraftMagicNumbers.getBlock((Material)oreConfig.getMaterial()).n().n();
    }

    @Override
    public boolean hasCustomData(@NotNull BlockState blockState) {
        TileEntity tileEntity = ((CraftWorld)blockState.getWorld()).getHandle().c_(new BlockPosition(blockState.getX(), blockState.getY(), blockState.getZ()));
        if (tileEntity == null) {
            return false;
        }
        return tileEntity.o().e() != 0;
    }

    @Override
    @NotNull
    public String getCustomData(@NotNull BlockState blockState) {
        TileEntity tileEntity = ((CraftWorld)blockState.getWorld()).getHandle().c_(new BlockPosition(blockState.getX(), blockState.getY(), blockState.getZ()));
        return tileEntity.o().toString();
    }
}

