/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_18_R1.customdata;

import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataApplier;
import io.th0rgal.oraxen.mechanics.MechanicsManager;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanicFactory;
import java.util.Optional;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.generator.LimitedRegion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraxenApplier_v1_18_R1
implements CustomDataApplier {
    private static final BlockFace[] BLOCK_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH, BlockFace.DOWN, BlockFace.UP};
    @NotNull
    private final CustomData customData;
    @Nullable
    private BlockMechanicFactory blockMechanicFactory;
    @Nullable
    private NoteBlockMechanicFactory noteBlockMechanicFactory;
    @Nullable
    private StringBlockMechanicFactory stringBlockMechanicFactory;

    public OraxenApplier_v1_18_R1(@NotNull CustomData customData) {
        Validate.notNull((Object)customData, (String)"CustomData can not be null");
        this.customData = customData;
    }

    @Override
    public void apply(@NotNull OreConfig oreConfig, @NotNull Object position, @NotNull Object blockAccess) {
        StringBlockMechanic stringBlockMechanic;
        NoteBlockMechanic noteBlockMechanic;
        BlockMechanic blockMechanic;
        Location location = (Location)position;
        LimitedRegion limitedRegion = (LimitedRegion)blockAccess;
        BlockData blockData = limitedRegion.getBlockData(location);
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            return;
        }
        String name = (String)objectOptional.get();
        if (this.blockMechanicFactory == null) {
            this.blockMechanicFactory = (BlockMechanicFactory)MechanicsManager.getMechanicFactory((String)"block");
        }
        if (this.noteBlockMechanicFactory == null) {
            this.noteBlockMechanicFactory = (NoteBlockMechanicFactory)MechanicsManager.getMechanicFactory((String)"noteblock");
        }
        if (this.stringBlockMechanicFactory == null) {
            this.stringBlockMechanicFactory = (StringBlockMechanicFactory)MechanicsManager.getMechanicFactory((String)"stringblock");
        }
        if (this.blockMechanicFactory != null && (blockMechanic = (BlockMechanic)this.blockMechanicFactory.getMechanic(name)) != null) {
            int code = blockMechanic.getCustomVariation();
            for (int i = 0; i < BLOCK_FACES.length; ++i) {
                ((MultipleFacing)blockData).setFace(BLOCK_FACES[i], (code & 1 << i) != 0);
            }
        }
        if (this.noteBlockMechanicFactory != null && (noteBlockMechanic = (NoteBlockMechanic)this.noteBlockMechanicFactory.getMechanic(name)) != null) {
            blockData = NoteBlockMechanicFactory.createNoteBlockData((int)noteBlockMechanic.getCustomVariation());
        }
        if (this.stringBlockMechanicFactory != null && (stringBlockMechanic = (StringBlockMechanic)this.stringBlockMechanicFactory.getMechanic(name)) != null) {
            blockData = StringBlockMechanicFactory.createTripwireData((int)stringBlockMechanic.getCustomVariation());
        }
        limitedRegion.setBlockData(location, blockData);
    }
}

