/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_18_R1.customdata;

import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataApplier;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.generator.LimitedRegion;
import org.jetbrains.annotations.NotNull;

public class FacingApplier_v1_18_R1
implements CustomDataApplier {
    private static final Map<String, BlockFace> DIRECTION_MAP = new HashMap<String, BlockFace>(6);
    @NonNull
    private final CustomData customData;

    @Override
    public void apply(@NotNull OreConfig oreConfig, @NotNull Object position, @NotNull Object blockAccess) {
        Location location = (Location)position;
        LimitedRegion limitedRegion = (LimitedRegion)blockAccess;
        Directional blockData = (Directional)limitedRegion.getBlockData(location);
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            return;
        }
        String facing = (String)objectOptional.get();
        blockData.setFacing(DIRECTION_MAP.get(facing.toUpperCase()));
        limitedRegion.setBlockData(location, (BlockData)blockData);
    }

    public FacingApplier_v1_18_R1(@NonNull CustomData customData) {
        if (customData == null) {
            throw new NullPointerException("customData is marked non-null but is null");
        }
        this.customData = customData;
    }

    static {
        DIRECTION_MAP.put("UP", BlockFace.UP);
        DIRECTION_MAP.put("DOWN", BlockFace.DOWN);
        DIRECTION_MAP.put("WEST", BlockFace.WEST);
        DIRECTION_MAP.put("SOUTH", BlockFace.SOUTH);
        DIRECTION_MAP.put("EAST", BlockFace.EAST);
        DIRECTION_MAP.put("NORTH", BlockFace.NORTH);
    }
}

