/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_17_R1.customdata;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractNBTTagCustomData;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.entity.TileEntity;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftMagicNumbers;
import org.bukkit.generator.LimitedRegion;
import org.jetbrains.annotations.NotNull;

public class NBTTagApplier_v1_17_R1
implements AbstractNBTTagCustomData.NBTTagApplier {
    @NotNull
    private final CustomData customData;

    public NBTTagApplier_v1_17_R1(@NotNull CustomData data) {
        Validate.notNull((Object)data, (String)"CustomData can not be null");
        this.customData = data;
    }

    @Override
    public void apply(@NotNull OreConfig oreConfig, @NotNull Object position, @NotNull Object blockAccess) {
        Location location = (Location)position;
        LimitedRegion limitedRegion = (LimitedRegion)blockAccess;
        BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        GeneratorAccessSeed generatorAccess = ((CraftLimitedRegion)limitedRegion).getHandle();
        TileEntity tileEntity = generatorAccess.getTileEntity(blockPosition);
        if (tileEntity == null) {
            return;
        }
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            return;
        }
        String nbtTag = (String)objectOptional.get();
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        tileEntity.save(nbtTagCompound);
        try {
            NBTTagCompound nbtTagCompound1 = MojangsonParser.parse((String)nbtTag);
            nbtTagCompound.a(nbtTagCompound1);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException("Error while parsing String to NBTTagCompound", e);
        }
        tileEntity.load(nbtTagCompound);
        generatorAccess.A(blockPosition).removeTileEntity(blockPosition);
        generatorAccess.A(blockPosition).setTileEntity(tileEntity);
    }

    @Override
    public boolean isValidCustomData(@NotNull String customData, @NotNull OreConfig oreConfig) {
        try {
            MojangsonParser.parse((String)customData);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean canApply(@NotNull OreConfig oreConfig) {
        return CraftMagicNumbers.getBlock((Material)oreConfig.getMaterial()).getBlockData().isTileEntity();
    }

    @Override
    public boolean hasCustomData(@NotNull BlockState blockState) {
        TileEntity tileEntity = ((CraftWorld)blockState.getWorld()).getHandle().getTileEntity(new BlockPosition(blockState.getX(), blockState.getY(), blockState.getZ()));
        if (tileEntity == null) {
            return false;
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        tileEntity.save(nbtTagCompound);
        return nbtTagCompound.e() > 4;
    }

    @Override
    @NotNull
    public String getCustomData(@NotNull BlockState blockState) {
        TileEntity tileEntity = ((CraftWorld)blockState.getWorld()).getHandle().getTileEntity(new BlockPosition(blockState.getX(), blockState.getY(), blockState.getZ()));
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        tileEntity.save(nbtTagCompound);
        nbtTagCompound.remove("id");
        nbtTagCompound.remove("x");
        nbtTagCompound.remove("y");
        nbtTagCompound.remove("z");
        return nbtTagCompound.toString();
    }
}

