/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_17_R1;

import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.api.WorldConfig;
import de.derfrzocker.custom.ore.generator.impl.v1_17_R1.ChunkAccessImpl;
import de.derfrzocker.custom.ore.generator.impl.v1_17_R1.WorldHandler_v1_17_R1;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_17_R1.generator.CraftLimitedRegion;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;

public class CustomOrePopulator
extends BlockPopulator {
    @NotNull
    private final World world;
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    @NotNull
    private final WorldHandler_v1_17_R1 worldHandler;

    public CustomOrePopulator(@NotNull World world, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull WorldHandler_v1_17_R1 worldHandler) {
        Validate.notNull((Object)world, (String)"World cannot be null");
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)worldHandler, (String)"WorldHandler can not be null");
        this.world = world;
        this.serviceSupplier = serviceSupplier;
        this.worldHandler = worldHandler;
    }

    public void populate(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull LimitedRegion limitedRegion) {
        Set<Biome> biomes = this.getBiomes(chunkX, chunkZ, limitedRegion);
        CustomOreGeneratorService service = this.serviceSupplier.get();
        Optional<WorldConfig> optional = service.getWorldConfig(this.world.getName());
        if (!optional.isPresent()) {
            return;
        }
        WorldConfig worldConfig = optional.get();
        biomes.forEach(biome -> {
            List<OreConfig> oreConfigs = Arrays.asList((OreConfig[])worldConfig.getOreConfigs().stream().filter(oreConfig -> oreConfig.getBiomes().contains(biome) || oreConfig.shouldGeneratedAll()).filter(OreConfig::isActivated).toArray(OreConfig[]::new));
            oreConfigs.forEach(oreConfig -> this.generate((OreConfig)oreConfig, chunkX, chunkZ, limitedRegion, (Biome)biome, service));
        });
    }

    private Set<Biome> getBiomes(int chunkX, int chunkZ, LimitedRegion limitedRegion) {
        HashSet<Biome> set = new HashSet<Biome>();
        int x = chunkX << 4;
        int z = chunkZ << 4;
        for (int x2 = x; x2 < x + 16; ++x2) {
            for (int z2 = z; z2 < z + 16; ++z2) {
                try {
                    set.add(limitedRegion.getBiome(x2, 60, z2));
                    continue;
                }
                catch (Exception ignored) {
                    System.out.println("Biome not Found");
                }
            }
        }
        return set;
    }

    private void generate(OreConfig oreConfig, int chunkX, int chunkZ, @NotNull LimitedRegion limitedRegion, Biome biome, CustomOreGeneratorService service) {
        Optional<OreGenerator> optionalOreGenerator = service.getOreGenerator(oreConfig.getOreGenerator());
        Optional<BlockSelector> optionalBlockSelector = service.getBlockSelector(oreConfig.getBlockSelector());
        if (!optionalOreGenerator.isPresent()) {
            return;
        }
        if (!optionalBlockSelector.isPresent()) {
            return;
        }
        OreGenerator oreGenerator = optionalOreGenerator.get();
        BlockSelector blockSelector = optionalBlockSelector.get();
        Random random = service.createRandom(this.world.getSeed() + (long)oreConfig.getMaterial().toString().hashCode() + (long)oreConfig.getName().hashCode(), chunkX, chunkZ);
        BlockPosition blockPosition = new BlockPosition(chunkX << 4, 0, chunkZ << 4);
        Set<Location> locations = blockSelector.selectBlocks((x, z) -> ((CraftLimitedRegion)limitedRegion).getHandle().a(HeightMap.Type.e, blockPosition.getX() + x, blockPosition.getZ() + z), oreConfig, random);
        HashSet<Location> biomeLocations = new HashSet<Location>();
        Location chunkPosition = new Location(null, (double)(chunkX << 4), 0.0, (double)(chunkZ << 4));
        Set<Material> replaceMaterials = oreConfig.getReplaceMaterials();
        Set<Material> selectMaterials = oreConfig.getSelectMaterials();
        if (selectMaterials.isEmpty()) {
            selectMaterials = replaceMaterials;
        }
        Set<Material> finalSelectMaterials = selectMaterials;
        locations.stream().filter(location -> this.checkBlockAndBiome(limitedRegion, chunkPosition, (Location)location, biome, finalSelectMaterials)).forEach(biomeLocations::add);
        ChunkAccessImpl chunkAccess = new ChunkAccessImpl((GeneratorAccess)((CraftLimitedRegion)limitedRegion).getHandle());
        oreGenerator.generate(oreConfig, chunkAccess, chunkX, chunkZ, random, biome, biomeLocations);
        chunkAccess.refreshTiles();
        chunkAccess.updateList();
        for (BlockPosition pos : chunkAccess.getBlocks()) {
            oreConfig.getCustomData().forEach((customData, object) -> customData.getCustomDataApplier().apply(oreConfig, new Location(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), limitedRegion));
        }
    }

    private boolean checkBlockAndBiome(LimitedRegion limitedRegion, Location chunkPosition, Location location, Biome biome, Set<Material> materials) {
        boolean isBiome;
        Location blockPosition = chunkPosition.clone().add((double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ());
        boolean bl = isBiome = limitedRegion.getBiome(blockPosition) == biome;
        if (!isBiome) {
            return false;
        }
        return materials.contains(limitedRegion.getType(blockPosition));
    }
}

