/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_16_R3.customdata;

import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataApplier;
import io.th0rgal.oraxen.mechanics.MechanicsManager;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanicFactory;
import java.util.Optional;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.BlockStateBoolean;
import net.minecraft.server.v1_16_R3.EnumDirection;
import net.minecraft.server.v1_16_R3.GeneratorAccess;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IBlockState;
import org.apache.commons.lang.Validate;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.NoteBlock;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraxenApplier_v1_16_R3
implements CustomDataApplier {
    private static final EnumDirection[] DIRECTIONS = new EnumDirection[]{EnumDirection.EAST, EnumDirection.WEST, EnumDirection.SOUTH, EnumDirection.NORTH, EnumDirection.DOWN, EnumDirection.UP};
    @NotNull
    private final CustomData customData;
    @Nullable
    private BlockMechanicFactory blockMechanicFactory;
    @Nullable
    private NoteBlockMechanicFactory noteBlockMechanicFactory;
    @Nullable
    private StringBlockMechanicFactory stringBlockMechanicFactory;

    public OraxenApplier_v1_16_R3(@NotNull CustomData customData) {
        Validate.notNull((Object)customData, (String)"CustomData can not be null");
        this.customData = customData;
    }

    @Override
    public void apply(@NotNull OreConfig oreConfig, @NotNull Object location, @NotNull Object blockAccess) {
        StringBlockMechanic stringBlockMechanic;
        NoteBlockMechanic noteBlockMechanic;
        BlockMechanic blockMechanic;
        BlockPosition blockPosition = (BlockPosition)location;
        GeneratorAccess generatorAccess = (GeneratorAccess)blockAccess;
        IBlockData iBlockData = generatorAccess.getType(blockPosition);
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            return;
        }
        String name = (String)objectOptional.get();
        if (this.blockMechanicFactory == null) {
            this.blockMechanicFactory = (BlockMechanicFactory)MechanicsManager.getMechanicFactory((String)"block");
        }
        if (this.noteBlockMechanicFactory == null) {
            this.noteBlockMechanicFactory = (NoteBlockMechanicFactory)MechanicsManager.getMechanicFactory((String)"noteblock");
        }
        if (this.stringBlockMechanicFactory == null) {
            this.stringBlockMechanicFactory = (StringBlockMechanicFactory)MechanicsManager.getMechanicFactory((String)"stringblock");
        }
        if (this.blockMechanicFactory != null && (blockMechanic = (BlockMechanic)this.blockMechanicFactory.getMechanic(name)) != null) {
            int code = blockMechanic.getCustomVariation();
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                EnumDirection direction = DIRECTIONS[i];
                BlockStateBoolean blockStateBoolean = (BlockStateBoolean)iBlockData.getBlock().getStates().a(direction.name().toLowerCase());
                iBlockData = (IBlockData)iBlockData.set((IBlockState)blockStateBoolean, (Comparable)Boolean.valueOf((code & 1 << i) != 0));
            }
        }
        if (this.noteBlockMechanicFactory != null && (noteBlockMechanic = (NoteBlockMechanic)this.noteBlockMechanicFactory.getMechanic(name)) != null) {
            NoteBlock blockData = NoteBlockMechanicFactory.createNoteBlockData((int)noteBlockMechanic.getCustomVariation());
            iBlockData = ((CraftBlockData)blockData).getState();
        }
        if (this.stringBlockMechanicFactory != null && (stringBlockMechanic = (StringBlockMechanic)this.stringBlockMechanicFactory.getMechanic(name)) != null) {
            BlockData blockData = StringBlockMechanicFactory.createTripwireData((int)stringBlockMechanic.getCustomVariation());
            iBlockData = ((CraftBlockData)blockData).getState();
        }
        generatorAccess.setTypeAndData(blockPosition, iBlockData, 2);
    }
}

