/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_16_R2.customdata;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractNBTTagCustomData;
import java.util.Optional;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.GeneratorAccess;
import net.minecraft.server.v1_16_R2.MojangsonParser;
import net.minecraft.server.v1_16_R2.NBTTagCompound;
import net.minecraft.server.v1_16_R2.TileEntity;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R2.util.CraftMagicNumbers;
import org.jetbrains.annotations.NotNull;

public class NBTTagApplier_v1_16_R2
implements AbstractNBTTagCustomData.NBTTagApplier {
    @NotNull
    private final CustomData customData;

    public NBTTagApplier_v1_16_R2(@NotNull CustomData data) {
        Validate.notNull((Object)data, (String)"CustomData can not be null");
        this.customData = data;
    }

    @Override
    public void apply(@NotNull OreConfig oreConfig, @NotNull Object location, @NotNull Object blockAccess) {
        GeneratorAccess generatorAccess = (GeneratorAccess)blockAccess;
        BlockPosition blockPosition = (BlockPosition)location;
        TileEntity tileEntity = generatorAccess.getTileEntity(blockPosition);
        if (tileEntity == null) {
            return;
        }
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            return;
        }
        String nbtTag = (String)objectOptional.get();
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        tileEntity.save(nbtTagCompound);
        try {
            NBTTagCompound nbtTagCompound1 = MojangsonParser.parse((String)nbtTag);
            nbtTagCompound.a(nbtTagCompound1);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException("Error while parsing String to NBTTagCompound", e);
        }
        tileEntity.load(generatorAccess.getType(blockPosition), nbtTagCompound);
        generatorAccess.z(blockPosition).removeTileEntity(blockPosition);
        generatorAccess.z(blockPosition).setTileEntity(blockPosition, tileEntity);
    }

    @Override
    public boolean isValidCustomData(@NotNull String customData, @NotNull OreConfig oreConfig) {
        try {
            MojangsonParser.parse((String)customData);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean canApply(@NotNull OreConfig oreConfig) {
        return CraftMagicNumbers.getBlock((Material)oreConfig.getMaterial()).isTileEntity();
    }

    @Override
    public boolean hasCustomData(@NotNull BlockState blockState) {
        TileEntity tileEntity = ((CraftWorld)blockState.getWorld()).getHandle().getTileEntity(new BlockPosition(blockState.getX(), blockState.getY(), blockState.getZ()));
        if (tileEntity == null) {
            return false;
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        tileEntity.save(nbtTagCompound);
        return nbtTagCompound.e() > 4;
    }

    @Override
    @NotNull
    public String getCustomData(@NotNull BlockState blockState) {
        TileEntity tileEntity = ((CraftWorld)blockState.getWorld()).getHandle().getTileEntity(new BlockPosition(blockState.getX(), blockState.getY(), blockState.getZ()));
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        tileEntity.save(nbtTagCompound);
        nbtTagCompound.remove("id");
        nbtTagCompound.remove("x");
        nbtTagCompound.remove("y");
        nbtTagCompound.remove("z");
        return nbtTagCompound.toString();
    }
}

