/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_16_R2.customdata;

import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataApplier;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.BlockStateDirection;
import net.minecraft.server.v1_16_R2.EnumDirection;
import net.minecraft.server.v1_16_R2.GeneratorAccess;
import net.minecraft.server.v1_16_R2.IBlockData;
import net.minecraft.server.v1_16_R2.IBlockState;

public class FacingApplier_v1_16_R2
implements CustomDataApplier {
    private static final Map<String, EnumDirection> DIRECTION_MAP = new HashMap<String, EnumDirection>(6);
    @NonNull
    private final CustomData customData;

    @Override
    public void apply(OreConfig oreConfig, Object location, Object blockAccess) {
        GeneratorAccess generatorAccess = (GeneratorAccess)blockAccess;
        BlockPosition blockPosition = (BlockPosition)location;
        IBlockData iBlockData = generatorAccess.getType(blockPosition);
        BlockStateDirection blockStateDirection = (BlockStateDirection)iBlockData.getBlock().getStates().a("facing");
        if (blockStateDirection == null) {
            return;
        }
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            return;
        }
        String facing = (String)objectOptional.get();
        iBlockData = (IBlockData)iBlockData.set((IBlockState)blockStateDirection, (Comparable)DIRECTION_MAP.get(facing.toUpperCase()));
        generatorAccess.setTypeAndData(blockPosition, iBlockData, 2);
    }

    public FacingApplier_v1_16_R2(@NonNull CustomData customData) {
        if (customData == null) {
            throw new NullPointerException("customData is marked non-null but is null");
        }
        this.customData = customData;
    }

    static {
        DIRECTION_MAP.put("UP", EnumDirection.UP);
        DIRECTION_MAP.put("DOWN", EnumDirection.DOWN);
        DIRECTION_MAP.put("WEST", EnumDirection.WEST);
        DIRECTION_MAP.put("SOUTH", EnumDirection.SOUTH);
        DIRECTION_MAP.put("EAST", EnumDirection.EAST);
        DIRECTION_MAP.put("NORTH", EnumDirection.NORTH);
    }
}

