/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_16_R2;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.WorldHandler;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R2.ChunkOverrider;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import net.minecraft.server.v1_16_R2.ChunkGenerator;
import net.minecraft.server.v1_16_R2.PlayerChunkMap;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class WorldHandler_v1_16_R2
implements WorldHandler,
Listener {
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;

    public WorldHandler_v1_16_R2(@NotNull JavaPlugin javaPlugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier) {
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        this.serviceSupplier = serviceSupplier;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onWorldLoad(WorldInitEvent event) {
        if (!(event.getWorld() instanceof CraftWorld)) {
            return;
        }
        CraftWorld world = (CraftWorld)event.getWorld();
        try {
            PlayerChunkMap playerChunkMap = world.getHandle().getChunkProvider().playerChunkMap;
            Field ChunkGeneratorField = PlayerChunkMap.class.getDeclaredField("chunkGenerator");
            ChunkGeneratorField.setAccessible(true);
            Object chunkGeneratorObject = ChunkGeneratorField.get(playerChunkMap);
            if (!(chunkGeneratorObject instanceof ChunkGenerator)) {
                return;
            }
            ChunkGenerator chunkGenerator = (ChunkGenerator)chunkGeneratorObject;
            ChunkOverrider overrider = new ChunkOverrider((World)world, this.serviceSupplier, chunkGenerator, this);
            ChunkGeneratorField.set(playerChunkMap, (Object)overrider);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error while hook into world " + world.getName(), e);
        }
    }
}

