/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_16_R2;

import com.mojang.serialization.Codec;
import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.api.WorldConfig;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R2.GeneratorAccessOverrider;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R2.WorldHandler_v1_16_R2;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.v1_16_R2.BiomeBase;
import net.minecraft.server.v1_16_R2.BiomeManager;
import net.minecraft.server.v1_16_R2.BiomeSettingsMobs;
import net.minecraft.server.v1_16_R2.Block;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R2.ChunkGenerator;
import net.minecraft.server.v1_16_R2.DefinedStructureManager;
import net.minecraft.server.v1_16_R2.EnumCreatureType;
import net.minecraft.server.v1_16_R2.GeneratorAccess;
import net.minecraft.server.v1_16_R2.GeneratorAccessSeed;
import net.minecraft.server.v1_16_R2.HeightMap;
import net.minecraft.server.v1_16_R2.IBlockAccess;
import net.minecraft.server.v1_16_R2.IChunkAccess;
import net.minecraft.server.v1_16_R2.IRegistry;
import net.minecraft.server.v1_16_R2.IRegistryCustom;
import net.minecraft.server.v1_16_R2.IRegistryWritable;
import net.minecraft.server.v1_16_R2.MinecraftKey;
import net.minecraft.server.v1_16_R2.RegionLimitedWorldAccess;
import net.minecraft.server.v1_16_R2.StructureGenerator;
import net.minecraft.server.v1_16_R2.StructureManager;
import net.minecraft.server.v1_16_R2.StructureSettings;
import net.minecraft.server.v1_16_R2.WorldChunkManager;
import net.minecraft.server.v1_16_R2.WorldGenStage;
import net.minecraft.server.v1_16_R2.WorldServer;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_16_R2.util.CraftMagicNumbers;
import org.jetbrains.annotations.NotNull;

public class ChunkOverrider
extends ChunkGenerator {
    private static final Method a;
    @NotNull
    private final World world;
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    @NotNull
    private final ChunkGenerator parent;
    @NotNull
    private final WorldHandler_v1_16_R2 worldHandler;

    public ChunkOverrider(@NotNull World world, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull ChunkGenerator parent, @NotNull WorldHandler_v1_16_R2 worldHandler) {
        super(null, null);
        Validate.notNull((Object)world, (String)"World cannot be null");
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)parent, (String)"Parent ChunkGenerator can not be null");
        Validate.notNull((Object)worldHandler, (String)"WorldHandler can not be null");
        this.world = world;
        this.serviceSupplier = serviceSupplier;
        this.parent = parent;
        this.worldHandler = worldHandler;
    }

    public void addDecorations(RegionLimitedWorldAccess regionLimitedWorldAccess, StructureManager structuremanager) {
        this.parent.addDecorations(regionLimitedWorldAccess, structuremanager);
        Set<Biome> biomes = this.getBiomes(regionLimitedWorldAccess);
        CustomOreGeneratorService service = this.serviceSupplier.get();
        Optional<WorldConfig> optional = service.getWorldConfig(this.world.getName());
        if (!optional.isPresent()) {
            return;
        }
        WorldConfig worldConfig = optional.get();
        biomes.forEach(biome -> {
            List<OreConfig> oreConfigs = Arrays.asList((OreConfig[])worldConfig.getOreConfigs().stream().filter(oreConfig -> oreConfig.getBiomes().contains(biome) || oreConfig.shouldGeneratedAll()).filter(OreConfig::isActivated).toArray(OreConfig[]::new));
            oreConfigs.forEach(oreConfig -> this.generate((OreConfig)oreConfig, regionLimitedWorldAccess, (Biome)biome, service));
        });
    }

    protected Codec<? extends ChunkGenerator> a() {
        try {
            return (Codec)a.invoke((Object)this.parent, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Unexpected Error while invoke method getCarvingBiome", e);
        }
    }

    public void buildBase(RegionLimitedWorldAccess regionLimitedWorldAccess, IChunkAccess iChunkAccess) {
        this.parent.buildBase(regionLimitedWorldAccess, iChunkAccess);
    }

    public void buildNoise(GeneratorAccess generatorAccess, StructureManager structureManager, IChunkAccess iChunkAccess) {
        this.parent.buildNoise(generatorAccess, structureManager, iChunkAccess);
    }

    public int getBaseHeight(int i, int i1, HeightMap.Type type) {
        return this.parent.getBaseHeight(i, i1, type);
    }

    public IBlockAccess a(int i, int i1) {
        return this.parent.a(i, i1);
    }

    @Nullable
    public BlockPosition findNearestMapFeature(WorldServer worldserver, StructureGenerator<?> structuregenerator, BlockPosition blockposition, int i, boolean flag) {
        return this.parent.findNearestMapFeature(worldserver, structuregenerator, blockposition, i, flag);
    }

    public boolean a(ChunkCoordIntPair chunkcoordintpair) {
        return this.parent.a(chunkcoordintpair);
    }

    public int b(int i, int j, HeightMap.Type heightmap_type) {
        return this.parent.b(i, j, heightmap_type);
    }

    public int c(int i, int j, HeightMap.Type heightmap_type) {
        return this.parent.c(i, j, heightmap_type);
    }

    public int getGenerationDepth() {
        return this.parent.getGenerationDepth();
    }

    public int getSeaLevel() {
        return this.parent.getSeaLevel();
    }

    public int getSpawnHeight() {
        return this.parent.getSpawnHeight();
    }

    public List<BiomeSettingsMobs.c> getMobsFor(BiomeBase biomebase, StructureManager structuremanager, EnumCreatureType enumcreaturetype, BlockPosition blockposition) {
        return this.parent.getMobsFor(biomebase, structuremanager, enumcreaturetype, blockposition);
    }

    public StructureSettings getSettings() {
        return this.parent.getSettings();
    }

    public void addMobs(RegionLimitedWorldAccess regionlimitedworldaccess) {
        this.parent.addMobs(regionlimitedworldaccess);
    }

    public WorldChunkManager getWorldChunkManager() {
        return this.parent.getWorldChunkManager();
    }

    public void doCarving(long i, BiomeManager biomemanager, IChunkAccess ichunkaccess, WorldGenStage.Features worldgenstage_features) {
        this.parent.doCarving(i, biomemanager, ichunkaccess, worldgenstage_features);
    }

    public void createBiomes(IRegistry<BiomeBase> iregistry, IChunkAccess ichunkaccess) {
        this.parent.createBiomes(iregistry, ichunkaccess);
    }

    public void createStructures(IRegistryCustom iregistrycustom, StructureManager structuremanager, IChunkAccess ichunkaccess, DefinedStructureManager definedstructuremanager, long i) {
        this.parent.createStructures(iregistrycustom, structuremanager, ichunkaccess, definedstructuremanager, i);
    }

    public void storeStructures(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        this.parent.storeStructures(generatoraccessseed, structuremanager, ichunkaccess);
    }

    private Set<Biome> getBiomes(RegionLimitedWorldAccess access) {
        HashSet<Biome> set = new HashSet<Biome>();
        IRegistryWritable registry = access.r().b(IRegistry.ay);
        int x = access.a() << 4;
        int z = access.b() << 4;
        for (int x2 = x; x2 < x + 16; ++x2) {
            for (int z2 = z; z2 < z + 16; ++z2) {
                BiomeBase base = access.getBiome(new BlockPosition(x2, 60, z2));
                try {
                    set.add(Biome.valueOf((String)registry.getKey((Object)base).getKey().toUpperCase()));
                    continue;
                }
                catch (Exception ignored) {
                    System.out.println("Biome not Found");
                }
            }
        }
        return set;
    }

    private void generate(OreConfig oreConfig, RegionLimitedWorldAccess access, Biome biome, CustomOreGeneratorService service) {
        Optional<OreGenerator> optionalOreGenerator = service.getOreGenerator(oreConfig.getOreGenerator());
        Optional<BlockSelector> optionalBlockSelector = service.getBlockSelector(oreConfig.getBlockSelector());
        IRegistryWritable registry = access.r().b(IRegistry.ay);
        if (!optionalOreGenerator.isPresent()) {
            return;
        }
        if (!optionalBlockSelector.isPresent()) {
            return;
        }
        OreGenerator oreGenerator = optionalOreGenerator.get();
        BlockSelector blockSelector = optionalBlockSelector.get();
        Random random = service.createRandom(access.getSeed() + (long)oreConfig.getMaterial().toString().hashCode() + (long)oreConfig.getName().hashCode(), access.a(), access.b());
        BlockPosition blockPosition = new BlockPosition(access.a() << 4, 0, access.b() << 4);
        Set<Location> locations = blockSelector.selectBlocks((x, z) -> access.getHighestBlockYAt(HeightMap.Type.MOTION_BLOCKING, blockPosition.b(x, 0, z)).getY(), oreConfig, random);
        HashSet<Location> biomeLocations = new HashSet<Location>();
        BiomeBase biomeBase = (BiomeBase)registry.get(new MinecraftKey(biome.name().toLowerCase()));
        BlockPosition chunkPosition = new BlockPosition(access.a() << 4, 0, access.b() << 4);
        Set<Material> replaceMaterials = oreConfig.getReplaceMaterials();
        Set<Material> selectMaterials = oreConfig.getSelectMaterials();
        if (selectMaterials.isEmpty()) {
            selectMaterials = replaceMaterials;
        }
        HashSet selectBlocks = new HashSet();
        selectMaterials.forEach(material -> selectBlocks.add(CraftMagicNumbers.getBlock((Material)material)));
        locations.stream().filter(location -> this.checkBlockAndBiome(access, chunkPosition, (Location)location, biomeBase, selectBlocks)).forEach(biomeLocations::add);
        oreGenerator.generate(oreConfig, new GeneratorAccessOverrider((GeneratorAccessSeed)access, oreConfig), access.a(), access.b(), random, biome, biomeLocations);
    }

    private boolean checkBlockAndBiome(RegionLimitedWorldAccess access, BlockPosition chunkPosition, Location location, BiomeBase biomeBase, Set<Block> blocks) {
        boolean isBiome;
        BlockPosition blockPosition = chunkPosition.b(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        boolean bl = isBiome = access.getBiome(blockPosition) == biomeBase;
        if (!isBiome) {
            return false;
        }
        return blocks.contains(access.getType(blockPosition).getBlock());
    }

    static {
        try {
            a = ChunkGenerator.class.getDeclaredMethod("a", new Class[0]);
            a.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unexpected Error while get Method");
        }
    }
}

