/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_15_R1;

import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.api.WorldConfig;
import de.derfrzocker.custom.ore.generator.impl.v1_15_R1.DummyGeneratorAccess;
import de.derfrzocker.custom.ore.generator.impl.v1_15_R1.GeneratorAccessOverrider;
import de.derfrzocker.custom.ore.generator.impl.v1_15_R1.WorldHandler_v1_15_R1;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.v1_15_R1.BiomeBase;
import net.minecraft.server.v1_15_R1.BiomeManager;
import net.minecraft.server.v1_15_R1.Block;
import net.minecraft.server.v1_15_R1.BlockPosition;
import net.minecraft.server.v1_15_R1.ChunkGenerator;
import net.minecraft.server.v1_15_R1.DefinedStructureManager;
import net.minecraft.server.v1_15_R1.EnumCreatureType;
import net.minecraft.server.v1_15_R1.GeneratorAccess;
import net.minecraft.server.v1_15_R1.GeneratorSettingsDefault;
import net.minecraft.server.v1_15_R1.HeightMap;
import net.minecraft.server.v1_15_R1.IChunkAccess;
import net.minecraft.server.v1_15_R1.IRegistry;
import net.minecraft.server.v1_15_R1.MinecraftKey;
import net.minecraft.server.v1_15_R1.RegionLimitedWorldAccess;
import net.minecraft.server.v1_15_R1.StructureGenerator;
import net.minecraft.server.v1_15_R1.World;
import net.minecraft.server.v1_15_R1.WorldChunkManager;
import net.minecraft.server.v1_15_R1.WorldGenFeatureConfiguration;
import net.minecraft.server.v1_15_R1.WorldGenStage;
import net.minecraft.server.v1_15_R1.WorldServer;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftMagicNumbers;
import org.jetbrains.annotations.NotNull;

public class ChunkOverrider<C extends GeneratorSettingsDefault>
extends ChunkGenerator<C> {
    private static final Method getBiome;
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    @NotNull
    private final ChunkGenerator<C> parent;
    @NotNull
    private final WorldHandler_v1_15_R1 worldHandler;

    public ChunkOverrider(@NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull ChunkGenerator<C> parent, @NotNull WorldHandler_v1_15_R1 worldHandler) {
        super(DummyGeneratorAccess.INSTANCE, null, null);
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull(parent, (String)"Parent ChunkGenerator can not be null");
        Validate.notNull((Object)worldHandler, (String)"WorldHandler can not be null");
        this.serviceSupplier = serviceSupplier;
        this.parent = parent;
        this.worldHandler = worldHandler;
    }

    public void createBiomes(IChunkAccess ichunkaccess) {
        this.parent.createBiomes(ichunkaccess);
    }

    protected BiomeBase getBiome(BiomeManager biomemanager, BlockPosition blockposition) {
        try {
            return (BiomeBase)getBiome.invoke(this.parent, biomemanager, blockposition);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Unexpected Error while invoke method getCarvingBiome", e);
        }
    }

    public void doCarving(BiomeManager biomemanager, IChunkAccess ichunkaccess, WorldGenStage.Features worldgenstage_features) {
        this.parent.doCarving(biomemanager, ichunkaccess, worldgenstage_features);
    }

    @Nullable
    public BlockPosition findNearestMapFeature(World world, String s, BlockPosition blockPosition, int i, boolean b) {
        return this.parent.findNearestMapFeature(world, s, blockPosition, i, b);
    }

    public void addDecorations(RegionLimitedWorldAccess regionLimitedWorldAccess) {
        this.parent.addDecorations(regionLimitedWorldAccess);
        Set<Biome> biomes = this.getBiomes(regionLimitedWorldAccess);
        CustomOreGeneratorService service = this.serviceSupplier.get();
        Optional<WorldConfig> optional = service.getWorldConfig(this.parent.getWorld().getWorld().getName());
        if (!optional.isPresent()) {
            return;
        }
        WorldConfig worldConfig = optional.get();
        biomes.forEach(biome -> {
            List<OreConfig> oreConfigs = Arrays.asList((OreConfig[])worldConfig.getOreConfigs().stream().filter(oreConfig -> oreConfig.getBiomes().contains(biome) || oreConfig.shouldGeneratedAll()).filter(OreConfig::isActivated).toArray(OreConfig[]::new));
            oreConfigs.forEach(oreConfig -> this.generate((OreConfig)oreConfig, regionLimitedWorldAccess, (Biome)biome, service));
        });
    }

    public void buildBase(RegionLimitedWorldAccess regionLimitedWorldAccess, IChunkAccess iChunkAccess) {
        this.parent.buildBase(regionLimitedWorldAccess, iChunkAccess);
    }

    public void addMobs(RegionLimitedWorldAccess regionLimitedWorldAccess) {
        this.parent.addMobs(regionLimitedWorldAccess);
    }

    public C getSettings() {
        return (C)this.parent.getSettings();
    }

    public int getSpawnHeight() {
        return this.parent.getSpawnHeight();
    }

    public void doMobSpawning(WorldServer worldserver, boolean flag, boolean flag1) {
        this.parent.doMobSpawning(worldserver, flag, flag1);
    }

    public boolean canSpawnStructure(BiomeBase biomeBase, StructureGenerator<? extends WorldGenFeatureConfiguration> structureGenerator) {
        return this.parent.canSpawnStructure(biomeBase, structureGenerator);
    }

    @Nullable
    public <C1 extends WorldGenFeatureConfiguration> C1 getFeatureConfiguration(BiomeBase biomebase, StructureGenerator<C1> structuregenerator) {
        return (C1)this.parent.getFeatureConfiguration(biomebase, structuregenerator);
    }

    public WorldChunkManager getWorldChunkManager() {
        return this.parent.getWorldChunkManager();
    }

    public long getSeed() {
        return this.parent.getSeed();
    }

    public int getGenerationDepth() {
        return this.parent.getGenerationDepth();
    }

    public List<BiomeBase.BiomeMeta> getMobsFor(EnumCreatureType enumCreatureType, BlockPosition blockPosition) {
        return this.parent.getMobsFor(enumCreatureType, blockPosition);
    }

    public void createStructures(BiomeManager biomemanager, IChunkAccess ichunkaccess, ChunkGenerator<?> chunkgenerator, DefinedStructureManager definedstructuremanager) {
        this.parent.createStructures(biomemanager, ichunkaccess, chunkgenerator, definedstructuremanager);
    }

    public void storeStructures(GeneratorAccess generatoraccess, IChunkAccess ichunkaccess) {
        this.parent.storeStructures(generatoraccess, ichunkaccess);
    }

    public void buildNoise(GeneratorAccess generatorAccess, IChunkAccess iChunkAccess) {
        this.parent.buildNoise(generatorAccess, iChunkAccess);
    }

    public int getSeaLevel() {
        return this.parent.getSeaLevel();
    }

    public int getBaseHeight(int i, int i1, HeightMap.Type type) {
        return this.parent.getBaseHeight(i, i1, type);
    }

    public int b(int i, int j, HeightMap.Type heightmap_type) {
        return this.parent.b(i, j, heightmap_type);
    }

    public int c(int i, int j, HeightMap.Type heightmap_type) {
        return this.parent.c(i, j, heightmap_type);
    }

    public World getWorld() {
        return this.parent.getWorld();
    }

    private Set<Biome> getBiomes(RegionLimitedWorldAccess access) {
        HashSet<Biome> set = new HashSet<Biome>();
        int x = access.a() << 4;
        int z = access.b() << 4;
        for (int x2 = x; x2 < x + 16; ++x2) {
            for (int z2 = z; z2 < z + 16; ++z2) {
                BiomeBase base = access.getBiome(new BlockPosition(x2, 60, z2));
                try {
                    set.add(Biome.valueOf((String)IRegistry.BIOME.getKey((Object)base).getKey().toUpperCase()));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return set;
    }

    private void generate(OreConfig oreConfig, RegionLimitedWorldAccess access, Biome biome, CustomOreGeneratorService service) {
        Optional<OreGenerator> optionalOreGenerator = service.getOreGenerator(oreConfig.getOreGenerator());
        Optional<BlockSelector> optionalBlockSelector = service.getBlockSelector(oreConfig.getBlockSelector());
        if (!optionalOreGenerator.isPresent()) {
            return;
        }
        if (!optionalBlockSelector.isPresent()) {
            return;
        }
        OreGenerator oreGenerator = optionalOreGenerator.get();
        BlockSelector blockSelector = optionalBlockSelector.get();
        Random random = service.createRandom(access.getSeed() + (long)oreConfig.getMaterial().toString().hashCode() + (long)oreConfig.getName().hashCode(), access.a(), access.b());
        BlockPosition blockPosition = new BlockPosition(access.a() << 4, 0, access.b() << 4);
        Set<Location> locations = blockSelector.selectBlocks((x, z) -> access.getHighestBlockYAt(HeightMap.Type.MOTION_BLOCKING, blockPosition.b(x, 0, z)).getY(), oreConfig, random);
        HashSet<Location> biomeLocations = new HashSet<Location>();
        BiomeBase biomeBase = (BiomeBase)IRegistry.BIOME.get(new MinecraftKey(biome.name().toLowerCase()));
        BlockPosition chunkPosition = new BlockPosition(access.a() << 4, 0, access.b() << 4);
        Set<Material> replaceMaterials = oreConfig.getReplaceMaterials();
        Set<Material> selectMaterials = oreConfig.getSelectMaterials();
        if (selectMaterials.isEmpty()) {
            selectMaterials = replaceMaterials;
        }
        HashSet<Block> replaceBlocks = new HashSet<Block>();
        HashSet selectBlocks = new HashSet();
        replaceMaterials.forEach(material -> replaceBlocks.add(CraftMagicNumbers.getBlock((Material)material)));
        selectMaterials.forEach(material -> selectBlocks.add(CraftMagicNumbers.getBlock((Material)material)));
        locations.stream().filter(location -> this.checkBlockAndBiome(access, chunkPosition, (Location)location, biomeBase, selectBlocks)).forEach(biomeLocations::add);
        this.worldHandler.add(replaceBlocks);
        oreGenerator.generate(oreConfig, new GeneratorAccessOverrider((GeneratorAccess)access, oreConfig), access.a(), access.b(), random, biome, biomeLocations);
        this.worldHandler.remove();
    }

    private boolean checkBlockAndBiome(RegionLimitedWorldAccess access, BlockPosition chunkPosition, Location location, BiomeBase biomeBase, Set<Block> blocks) {
        boolean isBiome;
        BlockPosition blockPosition = chunkPosition.b(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        boolean bl = isBiome = access.getBiome(blockPosition) == biomeBase;
        if (!isBiome) {
            return false;
        }
        return blocks.contains(access.getType(blockPosition).getBlock());
    }

    static {
        try {
            getBiome = ChunkGenerator.class.getDeclaredMethod("getBiome", BiomeManager.class, BlockPosition.class);
            getBiome.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unexpected Error while get Method");
        }
    }
}

