/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_14_R1.customdata;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractSkullTextureCustomData;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.GeneratorAccess;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.TileEntity;
import net.minecraft.server.v1_14_R1.TileEntitySkull;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.jetbrains.annotations.NotNull;

public class SkullTextureApplier_v1_14_R1
implements AbstractSkullTextureCustomData.SkullTextureApplier {
    @NonNull
    private final CustomData customData;

    @Override
    public void apply(OreConfig oreConfig, Object location, Object blockAccess) {
        GeneratorAccess generatorAccess = (GeneratorAccess)blockAccess;
        BlockPosition blockPosition = (BlockPosition)location;
        TileEntity tileEntity = generatorAccess.getTileEntity(blockPosition);
        if (tileEntity == null) {
            return;
        }
        if (!(tileEntity instanceof TileEntitySkull)) {
            return;
        }
        TileEntitySkull skull = (TileEntitySkull)tileEntity;
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            return;
        }
        String texture = (String)objectOptional.get();
        GameProfile gameProfile = new GameProfile(UUID.nameUUIDFromBytes(texture.getBytes()), null);
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
        skull.setGameProfile(gameProfile);
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        skull.save(nbtTagCompound);
        generatorAccess.w(blockPosition).removeTileEntity(blockPosition);
        generatorAccess.w(blockPosition).a(nbtTagCompound);
    }

    @Override
    public boolean hasCustomData(@NotNull Skull skull) {
        TileEntity tileEntity = ((CraftWorld)skull.getWorld()).getHandle().getTileEntity(new BlockPosition(skull.getX(), skull.getY(), skull.getZ()));
        if (tileEntity == null) {
            return false;
        }
        if (!(tileEntity instanceof TileEntitySkull)) {
            return false;
        }
        GameProfile gameProfile = ((TileEntitySkull)tileEntity).gameProfile;
        if (gameProfile == null) {
            return false;
        }
        Collection propertyCollection = gameProfile.getProperties().get((Object)"textures");
        if (propertyCollection == null || propertyCollection.isEmpty()) {
            return false;
        }
        for (Property property : propertyCollection) {
            if (!property.getName().equals("textures")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCustomData(@NotNull Skull skull) {
        TileEntitySkull tileEntitySkull = (TileEntitySkull)((CraftWorld)skull.getWorld()).getHandle().getTileEntity(new BlockPosition(skull.getX(), skull.getY(), skull.getZ()));
        GameProfile gameProfile = tileEntitySkull.gameProfile;
        for (Property property : gameProfile.getProperties().get((Object)"textures")) {
            if (!property.getName().equals("textures")) continue;
            return property.getValue();
        }
        throw new RuntimeException("TileEntitySkull on Location " + tileEntitySkull.getPosition() + " dont have the property 'textures' in its GameProfile " + gameProfile);
    }

    public SkullTextureApplier_v1_14_R1(@NonNull CustomData customData) {
        if (customData == null) {
            throw new NullPointerException("customData is marked non-null but is null");
        }
        this.customData = customData;
    }
}

