/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_14_R1;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.WorldHandler;
import de.derfrzocker.custom.ore.generator.impl.v1_14_R1.ChunkOverrider;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.server.v1_14_R1.Block;
import net.minecraft.server.v1_14_R1.Blocks;
import net.minecraft.server.v1_14_R1.ChunkGenerator;
import net.minecraft.server.v1_14_R1.IBlockData;
import net.minecraft.server.v1_14_R1.PlayerChunkMap;
import net.minecraft.server.v1_14_R1.WorldGenFeatureOreConfiguration;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldHandler_v1_14_R1
implements WorldHandler,
Listener {
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    private final Map<Thread, Set<Block>> threadSetMap = Collections.synchronizedMap(new HashMap());

    public WorldHandler_v1_14_R1(@NotNull JavaPlugin javaPlugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier) {
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        this.serviceSupplier = serviceSupplier;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
        this.replaceTarget();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onWorldLoad(WorldInitEvent event) {
        if (!(event.getWorld() instanceof CraftWorld)) {
            return;
        }
        CraftWorld world = (CraftWorld)event.getWorld();
        try {
            PlayerChunkMap playerChunkMap = world.getHandle().getChunkProvider().playerChunkMap;
            Field ChunkGeneratorField = PlayerChunkMap.class.getDeclaredField("chunkGenerator");
            ChunkGeneratorField.setAccessible(true);
            Object chunkGeneratorObject = ChunkGeneratorField.get(playerChunkMap);
            if (!(chunkGeneratorObject instanceof ChunkGenerator)) {
                return;
            }
            ChunkGenerator chunkGenerator = (ChunkGenerator)chunkGeneratorObject;
            ChunkOverrider overrider = new ChunkOverrider(this.serviceSupplier, chunkGenerator, this);
            ChunkGeneratorField.set(playerChunkMap, (Object)overrider);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error while hook into world " + world.getName(), e);
        }
    }

    void remove() {
        this.threadSetMap.remove(Thread.currentThread());
    }

    void add(@Nullable Set<Block> blocks) {
        this.threadSetMap.put(Thread.currentThread(), blocks);
    }

    private void replaceTarget() {
        try {
            Field predicateField = WorldGenFeatureOreConfiguration.Target.class.getDeclaredField("e");
            predicateField.setAccessible(true);
            predicateField.set(WorldGenFeatureOreConfiguration.Target.NATURAL_STONE, this.getPredicate());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unexpected error while hook into WorldGenFeatureOreConfiguration Target", e);
        }
    }

    private Predicate<IBlockData> getPredicate() {
        return value -> {
            if (value == null) {
                return false;
            }
            Set<Block> blocks = this.threadSetMap.get(Thread.currentThread());
            Block block = value.getBlock();
            if (blocks == null) {
                return block == Blocks.STONE || block == Blocks.GRANITE || block == Blocks.DIORITE || block == Blocks.ANDESITE;
            }
            return blocks.contains(block);
        };
    }
}

