/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_13_R2.paper;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.WorldHandler;
import de.derfrzocker.custom.ore.generator.impl.v1_13_R2.paper.ChunkOverrieder;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import net.minecraft.server.v1_13_R2.ChunkGenerator;
import net.minecraft.server.v1_13_R2.ChunkProviderServer;
import net.minecraft.server.v1_13_R2.ChunkTaskScheduler;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class WorldHandler_v1_13_R2_paper
implements WorldHandler,
Listener {
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;

    public WorldHandler_v1_13_R2_paper(@NotNull JavaPlugin javaPlugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier) {
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        this.serviceSupplier = serviceSupplier;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onWorldLoad(WorldInitEvent event) {
        if (!(event.getWorld() instanceof CraftWorld)) {
            return;
        }
        CraftWorld world = (CraftWorld)event.getWorld();
        try {
            Field chunkSchedulerField = ChunkProviderServer.class.getDeclaredField("chunkScheduler");
            chunkSchedulerField.setAccessible(true);
            Object chunkSchedulerObject = chunkSchedulerField.get(world.getHandle().getChunkProvider());
            if (!(chunkSchedulerObject instanceof ChunkTaskScheduler)) {
                return;
            }
            Field ChunkGeneratorField = ChunkTaskScheduler.class.getDeclaredField("d");
            ChunkGeneratorField.setAccessible(true);
            Object chunkGeneratorObject = ChunkGeneratorField.get(chunkSchedulerObject);
            if (!(chunkGeneratorObject instanceof ChunkGenerator)) {
                return;
            }
            ChunkGenerator chunkGenerator = (ChunkGenerator)chunkGeneratorObject;
            ChunkOverrieder overrider = new ChunkOverrieder(this.serviceSupplier, chunkGenerator);
            ChunkGeneratorField.set(chunkSchedulerObject, overrider);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

