/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_13_R2;

import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.api.WorldConfig;
import de.derfrzocker.custom.ore.generator.impl.v1_13_R2.GeneratorAccessOverrider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.v1_13_R2.BiomeBase;
import net.minecraft.server.v1_13_R2.Block;
import net.minecraft.server.v1_13_R2.BlockPosition;
import net.minecraft.server.v1_13_R2.ChunkGenerator;
import net.minecraft.server.v1_13_R2.EnumCreatureType;
import net.minecraft.server.v1_13_R2.GeneratorAccess;
import net.minecraft.server.v1_13_R2.GeneratorSettings;
import net.minecraft.server.v1_13_R2.HeightMap;
import net.minecraft.server.v1_13_R2.IChunkAccess;
import net.minecraft.server.v1_13_R2.IRegistry;
import net.minecraft.server.v1_13_R2.MinecraftKey;
import net.minecraft.server.v1_13_R2.RegionLimitedWorldAccess;
import net.minecraft.server.v1_13_R2.StructureGenerator;
import net.minecraft.server.v1_13_R2.StructureStart;
import net.minecraft.server.v1_13_R2.World;
import net.minecraft.server.v1_13_R2.WorldChunkManager;
import net.minecraft.server.v1_13_R2.WorldGenFeatureConfiguration;
import net.minecraft.server.v1_13_R2.WorldGenStage;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.longs.LongSet;
import org.bukkit.craftbukkit.v1_13_R2.util.CraftMagicNumbers;
import org.jetbrains.annotations.NotNull;

public class ChunkOverrieder<C extends GeneratorSettings>
implements ChunkGenerator<C> {
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    @NotNull
    private final ChunkGenerator<C> parent;

    public ChunkOverrieder(@NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull ChunkGenerator<C> parent) {
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull(parent, (String)"Parent ChunkGenerator can not be null");
        this.serviceSupplier = serviceSupplier;
        this.parent = parent;
    }

    public void createChunk(IChunkAccess iChunkAccess) {
        this.parent.createChunk(iChunkAccess);
    }

    public void addFeatures(RegionLimitedWorldAccess regionLimitedWorldAccess, WorldGenStage.Features features) {
        this.parent.addFeatures(regionLimitedWorldAccess, features);
    }

    public void addDecorations(RegionLimitedWorldAccess regionLimitedWorldAccess) {
        this.parent.addDecorations(regionLimitedWorldAccess);
        Set<Biome> biomes = this.getBiomes(regionLimitedWorldAccess);
        CustomOreGeneratorService service = this.serviceSupplier.get();
        Optional<WorldConfig> optional = service.getWorldConfig(this.parent.getWorld().getWorld().getName());
        if (!optional.isPresent()) {
            return;
        }
        WorldConfig worldConfig = optional.get();
        biomes.forEach(biome -> {
            List<OreConfig> oreConfigs = Arrays.asList((OreConfig[])worldConfig.getOreConfigs().stream().filter(oreConfig -> oreConfig.getBiomes().contains(biome) || oreConfig.shouldGeneratedAll()).filter(OreConfig::isActivated).toArray(OreConfig[]::new));
            oreConfigs.forEach(oreConfig -> this.generate((OreConfig)oreConfig, regionLimitedWorldAccess, (Biome)biome, service));
        });
    }

    public void addMobs(RegionLimitedWorldAccess regionLimitedWorldAccess) {
        this.parent.addMobs(regionLimitedWorldAccess);
    }

    public List<BiomeBase.BiomeMeta> getMobsFor(EnumCreatureType enumCreatureType, BlockPosition blockPosition) {
        return this.parent.getMobsFor(enumCreatureType, blockPosition);
    }

    @Nullable
    public BlockPosition findNearestMapFeature(World world, String s, BlockPosition blockPosition, int i, boolean b) {
        return this.parent.findNearestMapFeature(world, s, blockPosition, i, b);
    }

    public C getSettings() {
        return (C)this.parent.getSettings();
    }

    public int a(World world, boolean b, boolean b1) {
        return this.parent.a(world, b, b1);
    }

    public boolean canSpawnStructure(BiomeBase biomeBase, StructureGenerator<? extends WorldGenFeatureConfiguration> structureGenerator) {
        return this.parent.canSpawnStructure(biomeBase, structureGenerator);
    }

    @Nullable
    public WorldGenFeatureConfiguration getFeatureConfiguration(BiomeBase biomeBase, StructureGenerator<? extends WorldGenFeatureConfiguration> structureGenerator) {
        return this.parent.getFeatureConfiguration(biomeBase, structureGenerator);
    }

    public Long2ObjectMap<StructureStart> getStructureStartCache(StructureGenerator<? extends WorldGenFeatureConfiguration> structureGenerator) {
        return this.parent.getStructureStartCache(structureGenerator);
    }

    public Long2ObjectMap<LongSet> getStructureCache(StructureGenerator<? extends WorldGenFeatureConfiguration> structureGenerator) {
        return this.parent.getStructureCache(structureGenerator);
    }

    public WorldChunkManager getWorldChunkManager() {
        return this.parent.getWorldChunkManager();
    }

    public long getSeed() {
        return this.parent.getSeed();
    }

    public int getSpawnHeight() {
        return this.parent.getSpawnHeight();
    }

    public int getGenerationDepth() {
        return this.parent.getGenerationDepth();
    }

    public World getWorld() {
        return this.parent.getWorld();
    }

    private Set<Biome> getBiomes(RegionLimitedWorldAccess access) {
        HashSet<Biome> set = new HashSet<Biome>();
        int x = access.a() << 4;
        int z = access.b() << 4;
        for (int x2 = x; x2 < x + 16; ++x2) {
            for (int z2 = z; z2 < z + 16; ++z2) {
                BiomeBase base = access.getBiome(new BlockPosition(x2, 60, z2));
                try {
                    set.add(Biome.valueOf((String)IRegistry.BIOME.getKey((Object)base).getKey().toUpperCase()));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return set;
    }

    private void generate(OreConfig oreConfig, RegionLimitedWorldAccess access, Biome biome, CustomOreGeneratorService service) {
        Optional<OreGenerator> optionalOreGenerator = service.getOreGenerator(oreConfig.getOreGenerator());
        Optional<BlockSelector> optionalBlockSelector = service.getBlockSelector(oreConfig.getBlockSelector());
        if (!optionalOreGenerator.isPresent()) {
            return;
        }
        if (!optionalBlockSelector.isPresent()) {
            return;
        }
        OreGenerator oreGenerator = optionalOreGenerator.get();
        BlockSelector blockSelector = optionalBlockSelector.get();
        Random random = service.createRandom(access.getSeed() + (long)oreConfig.getMaterial().toString().hashCode() + (long)oreConfig.getName().hashCode(), access.a(), access.b());
        BlockPosition blockPosition = new BlockPosition(access.a() << 4, 0, access.b() << 4);
        Set<Location> locations = blockSelector.selectBlocks((x, z) -> access.getHighestBlockYAt(HeightMap.Type.MOTION_BLOCKING, blockPosition.a(x, 0, z)).getY(), oreConfig, random);
        HashSet<Location> biomeLocations = new HashSet<Location>();
        BiomeBase biomeBase = (BiomeBase)IRegistry.BIOME.get(new MinecraftKey(biome.name().toLowerCase()));
        BlockPosition chunkPosition = new BlockPosition(access.a() << 4, 0, access.b() << 4);
        Set<Material> selectMaterials = oreConfig.getSelectMaterials();
        if (selectMaterials.isEmpty()) {
            selectMaterials = oreConfig.getReplaceMaterials();
        }
        HashSet selectBlocks = new HashSet();
        selectMaterials.forEach(material -> selectBlocks.add(CraftMagicNumbers.getBlock((Material)material)));
        locations.stream().filter(location -> this.checkBlockAndBiome(access, chunkPosition, (Location)location, biomeBase, selectBlocks)).forEach(biomeLocations::add);
        oreGenerator.generate(oreConfig, new GeneratorAccessOverrider((GeneratorAccess)access, oreConfig), access.a(), access.b(), random, biome, biomeLocations);
    }

    private boolean checkBlockAndBiome(RegionLimitedWorldAccess access, BlockPosition chunkPosition, Location location, BiomeBase biomeBase, Set<Block> blocks) {
        boolean isBiome;
        BlockPosition blockPosition = chunkPosition.a(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        boolean bl = isBiome = access.getBiome(blockPosition) == biomeBase;
        if (!isBiome) {
            return false;
        }
        return blocks.contains(access.getType(blockPosition).getBlock());
    }
}

