/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_13_R1.oregenerator;

import de.derfrzocker.custom.ore.generator.api.ChunkAccess;
import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.impl.oregenerator.AbstractMinableGenerator;
import de.derfrzocker.custom.ore.generator.utils.NumberUtil;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.v1_13_R1.Block;
import net.minecraft.server.v1_13_R1.BlockPosition;
import net.minecraft.server.v1_13_R1.ChunkGenerator;
import net.minecraft.server.v1_13_R1.GeneratorAccess;
import net.minecraft.server.v1_13_R1.IBlockData;
import net.minecraft.server.v1_13_R1.WorldGenFeatureConfiguration;
import net.minecraft.server.v1_13_R1.WorldGenFeatureOreConfiguration;
import net.minecraft.server.v1_13_R1.WorldGenMinable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_13_R1.util.CraftMagicNumbers;
import org.jetbrains.annotations.NotNull;

public class MinableGenerator_v1_13_R1
extends AbstractMinableGenerator {
    private final WorldGenMinable generator = new WorldGenMinable();

    public MinableGenerator_v1_13_R1(@NotNull Function<String, Info> infoFunction, @NotNull BiFunction<String, OreSetting, Info> oreSettingInfo) {
        super(infoFunction, oreSettingInfo);
    }

    @Override
    public void generate(@NotNull OreConfig config, @NotNull ChunkAccess chunkAccess, int x, int z, @NotNull Random random, @NotNull Biome biome, @NotNull Set<Location> locations) {
        int veinSize = NumberUtil.getInt(config.getOreGeneratorOreSettings().getValue(VEIN_SIZE).orElse(0.0), random);
        if (veinSize == 0) {
            return;
        }
        BlockPosition chunkPosition = new BlockPosition(x << 4, 0, z << 4);
        GeneratorAccess generatorAccess = (GeneratorAccess)chunkAccess;
        ChunkGenerator chunkGenerator = generatorAccess.getChunkProvider().getChunkGenerator();
        Set<Material> replaceMaterials = config.getReplaceMaterials();
        HashSet<Block> blocks = new HashSet<Block>();
        replaceMaterials.forEach(material -> blocks.add(CraftMagicNumbers.getBlock((Material)material)));
        WorldGenFeatureOreConfiguration worldGenFeatureOreConfiguration = new WorldGenFeatureOreConfiguration(this.getPredicate(blocks), CraftMagicNumbers.getBlock((Material)config.getMaterial()).getBlockData(), veinSize);
        for (Location location : locations) {
            this.generator.generate(generatorAccess, chunkGenerator, random, chunkPosition.a(location.getBlockX(), location.getBlockY(), location.getBlockZ()), (WorldGenFeatureConfiguration)worldGenFeatureOreConfiguration);
        }
    }

    private Predicate<IBlockData> getPredicate(@NotNull Set<Block> blocks) {
        return value -> {
            if (value == null) {
                return false;
            }
            Block block = value.getBlock();
            return blocks.contains(block);
        };
    }
}

