/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_13_R1.customdata;

import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractAutoCustomData;
import java.util.Optional;
import net.minecraft.server.v1_13_R1.BlockPosition;
import net.minecraft.server.v1_13_R1.GeneratorAccess;
import net.minecraft.server.v1_13_R1.NBTTagCompound;
import net.minecraft.server.v1_13_R1.TileEntity;
import net.minecraft.server.v1_13_R1.TileEntityCommand;
import net.minecraft.server.v1_13_R1.WorldServer;
import org.apache.commons.lang.Validate;
import org.bukkit.block.CommandBlock;
import org.bukkit.craftbukkit.v1_13_R1.CraftWorld;
import org.jetbrains.annotations.NotNull;

public class AutoApplier_v1_13_R1
implements AbstractAutoCustomData.AutoApplier {
    @NotNull
    private final CustomData customData;

    public AutoApplier_v1_13_R1(@NotNull CustomData data) {
        Validate.notNull((Object)data, (String)"CustomData can not be null");
        this.customData = data;
    }

    @Override
    public void apply(@NotNull OreConfig oreConfig, @NotNull Object location, @NotNull Object blockAccess) {
        GeneratorAccess generatorAccess = (GeneratorAccess)blockAccess;
        BlockPosition blockPosition = (BlockPosition)location;
        TileEntity tileEntity = generatorAccess.getTileEntity(blockPosition);
        if (tileEntity == null) {
            return;
        }
        if (!(tileEntity instanceof TileEntityCommand)) {
            return;
        }
        TileEntityCommand tileCommand = (TileEntityCommand)tileEntity;
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            return;
        }
        boolean auto = (Boolean)objectOptional.get();
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        tileCommand.save(nbtTagCompound);
        nbtTagCompound.setBoolean("auto", auto);
        nbtTagCompound.setBoolean("conditionMet", auto);
        generatorAccess.y(blockPosition).d(blockPosition);
        generatorAccess.y(blockPosition).a(nbtTagCompound);
    }

    @Override
    public boolean getCustomData(@NotNull CommandBlock commandBlock) {
        BlockPosition blockPosition;
        WorldServer worldServer = ((CraftWorld)commandBlock.getWorld()).getHandle();
        TileEntity tileEntity = worldServer.getTileEntity(blockPosition = new BlockPosition(commandBlock.getX(), commandBlock.getY(), commandBlock.getZ()));
        if (tileEntity == null) {
            return false;
        }
        if (!(tileEntity instanceof TileEntityCommand)) {
            return false;
        }
        TileEntityCommand tileEntityCommand = (TileEntityCommand)tileEntity;
        return tileEntityCommand.e();
    }
}

