/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_13_R1;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.WorldHandler;
import de.derfrzocker.custom.ore.generator.impl.v1_13_R1.ChunkOverrieder;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import net.minecraft.server.v1_13_R1.ChunkProviderServer;
import net.minecraft.server.v1_13_R1.ChunkTaskScheduler;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_13_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R1.generator.InternalChunkGenerator;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class WorldHandler_v1_13_R1
implements WorldHandler,
Listener {
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;

    public WorldHandler_v1_13_R1(@NotNull JavaPlugin javaPlugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier) {
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        this.serviceSupplier = serviceSupplier;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onWorldLoad(@NotNull WorldInitEvent event) {
        if (!(event.getWorld() instanceof CraftWorld)) {
            return;
        }
        CraftWorld world = (CraftWorld)event.getWorld();
        if (world.getHandle().generator instanceof InternalChunkGenerator) {
            return;
        }
        ChunkOverrieder overrider = new ChunkOverrieder(this.serviceSupplier, ((ChunkProviderServer)world.getHandle().getChunkProvider()).chunkGenerator);
        try {
            Field field = ChunkProviderServer.class.getDeclaredField("chunkGenerator");
            field.setAccessible(true);
            field.set(world.getHandle().getChunkProvider(), overrider);
            field = ChunkProviderServer.class.getDeclaredField("f");
            field.setAccessible(true);
            Object object = field.get(world.getHandle().getChunkProvider());
            Field field2 = ChunkTaskScheduler.class.getDeclaredField("d");
            field2.setAccessible(true);
            field2.set(object, overrider);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

