/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.v1_12_R1.customdata;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractBlockStateCustomData;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.server.v1_12_R1.Block;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.BlockStateList;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.IBlockState;
import net.minecraft.server.v1_12_R1.World;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftMagicNumbers;
import org.jetbrains.annotations.NotNull;

public class BlockStateApplier_v1_12_R1
implements AbstractBlockStateCustomData.BlockStateApplier {
    @NotNull
    private final Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    @NotNull
    private final CustomData customData;

    public BlockStateApplier_v1_12_R1(@NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull CustomData customData) {
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)customData, (String)"CustomData can not be null");
        this.serviceSupplier = serviceSupplier;
        this.customData = customData;
    }

    @Override
    public void apply(@NotNull OreConfig oreConfig, @NotNull Object location, @NotNull Object blockAccess) {
        BlockPosition blockPosition = (BlockPosition)location;
        World world = (World)blockAccess;
        IBlockData iBlockData = world.getType(blockPosition);
        Optional<Object> objectOptional = oreConfig.getCustomData(this.customData);
        if (!objectOptional.isPresent()) {
            this.serviceSupplier.get().getLogger().warning("No CustomData value found for the CustomData '" + this.customData.getName() + "' in the ore-config with the name '" + oreConfig.getName() + "'!");
            this.serviceSupplier.get().getLogger().warning("Ignoring it!");
            return;
        }
        String customData = (String)objectOptional.get();
        Cache cache = this.caches.get(oreConfig.getName());
        if (cache == null || cache.getHash() != customData.hashCode() || cache.getMaterial() != oreConfig.getMaterial()) {
            cache = this.buildCache(iBlockData.getBlock(), oreConfig.getMaterial(), customData);
            this.caches.put(oreConfig.getName(), cache);
        }
        for (Pair entry : cache.getAll()) {
            iBlockData = entry.apply(iBlockData);
        }
        world.setTypeAndData(blockPosition, iBlockData, 2);
    }

    @Override
    public boolean canApply(@NotNull OreConfig oreConfig) {
        return !CraftMagicNumbers.getBlock((Material)oreConfig.getMaterial()).s().a().isEmpty();
    }

    @Override
    public boolean isValidCustomData(@NotNull String customData, @NotNull OreConfig oreConfig) {
        if (!customData.startsWith("[")) {
            return false;
        }
        if (!customData.endsWith("]")) {
            return false;
        }
        if (customData.length() < 5) {
            return false;
        }
        customData = customData.substring(1);
        customData = customData.substring(0, customData.length() - 1);
        String[] keyValues = customData.split(",");
        BlockStateList blockStateList = CraftMagicNumbers.getBlock((Material)oreConfig.getMaterial()).s();
        for (String keyValue : keyValues) {
            String[] split = keyValue.split("=");
            if (split.length != 2) {
                return false;
            }
            String key = split[0].trim().toLowerCase();
            String value = split[1].trim().toLowerCase();
            IBlockState iBlockState = blockStateList.a(key);
            if (iBlockState == null) {
                return false;
            }
            com.google.common.base.Optional optional = iBlockState.b(value);
            if (optional.isPresent()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasCustomData(@NotNull BlockState blockState) {
        IBlockData iBlockData = ((CraftWorld)blockState.getWorld()).getHandle().getType(new BlockPosition(blockState.getX(), blockState.getY(), blockState.getZ()));
        return iBlockData.getBlock().s().d().size() != 0;
    }

    @Override
    @NotNull
    public String getCustomData(@NotNull BlockState blockState) {
        IBlockData iBlockData = ((CraftWorld)blockState.getWorld()).getHandle().getType(new BlockPosition(blockState.getX(), blockState.getY(), blockState.getZ()));
        StringBuilder stringBuilder = new StringBuilder("[");
        boolean first = true;
        for (IBlockState iBlockState : iBlockData.getBlock().s().d()) {
            if (!first) {
                stringBuilder.append(",");
            } else {
                first = false;
            }
            stringBuilder.append(iBlockState.a());
            stringBuilder.append(",");
            stringBuilder.append(iBlockState.a(iBlockData.get(iBlockState)));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @NotNull
    private Cache buildCache(@NotNull Block block, @NotNull Material material, @NotNull String input) {
        Cache cache = new Cache(input.hashCode(), material);
        if (input.startsWith("[")) {
            input = input.substring(1);
        }
        if (input.endsWith("]")) {
            input = input.substring(0, input.length() - 1);
        }
        String[] keyValues = input.split(",");
        BlockStateList blockStateList = block.s();
        for (String keyValue : keyValues) {
            String[] split = keyValue.split("=");
            String key = split[0].trim().toLowerCase();
            String value = split[1].trim().toLowerCase();
            IBlockState iBlockState = blockStateList.a(key);
            if (iBlockState == null) {
                this.serviceSupplier.get().getLogger().warning("Found no IBlockState with the name '" + key + "' in the block with the name '" + Block.REGISTRY.b((Object)block) + "'!");
                this.serviceSupplier.get().getLogger().warning("Ignoring it!");
                continue;
            }
            com.google.common.base.Optional optional = iBlockState.b(value);
            if (optional.isPresent()) {
                cache.add(iBlockState, (Comparable)optional.get());
                continue;
            }
            this.serviceSupplier.get().getLogger().warning("Found no value with the name '" + value + "' in the IBlockState with the name '" + key + "'!");
            this.serviceSupplier.get().getLogger().warning("Ignoring it!");
        }
        return cache;
    }

    private static final class Cache {
        private final int hash;
        @NotNull
        private final Material material;
        @NotNull
        private final Set<Pair<?, ?>> values = new HashSet();

        private Cache(int hash, @NotNull Material material) {
            this.hash = hash;
            this.material = material;
        }

        private <T extends Comparable<T>, V extends T> void add(@NotNull IBlockState<T> key, @NotNull V value) {
            this.values.add(new Pair((IBlockState)key, (Comparable)value, null));
        }

        private Set<Pair<?, ?>> getAll() {
            return this.values;
        }

        private int getHash() {
            return this.hash;
        }

        @NotNull
        public Material getMaterial() {
            return this.material;
        }
    }

    private static final class Pair<T extends Comparable<T>, V extends T> {
        @NotNull
        private final IBlockState<T> iBlockState;
        @NotNull
        private final V value;

        private Pair(@NotNull IBlockState<T> iBlockState, @NotNull V value) {
            this.iBlockState = iBlockState;
            this.value = value;
        }

        @NotNull
        private IBlockData apply(@NotNull IBlockData iBlockData) {
            return iBlockData.set(this.iBlockState, this.value);
        }

        /* synthetic */ Pair(IBlockState x0, Comparable x1, 1 x2) {
            this(x0, x1);
        }
    }
}

