/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.oregenerator;

import de.derfrzocker.custom.ore.generator.api.ChunkAccess;
import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.impl.oregenerator.AbstractSingleOreGenerator;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;

public class SingleOreGenerator
extends AbstractSingleOreGenerator {
    public SingleOreGenerator(@NotNull Function<String, Info> infoFunction, @NotNull BiFunction<String, OreSetting, Info> oreSettingInfo) {
        super(infoFunction, oreSettingInfo);
    }

    @Override
    public void generate(@NotNull OreConfig config, @NotNull ChunkAccess chunkAccess, int x, int z, @NotNull Random random, @NotNull Biome biome, @NotNull Set<Location> locations) {
        Location chunkLocation = new Location(null, (double)(x << 4), 0.0, (double)(z << 4));
        Material material = config.getMaterial();
        Set<Material> replaceMaterials = config.getReplaceMaterials();
        for (Location location : locations) {
            int zPosition;
            int yPosition;
            int xPosition = chunkLocation.getBlockX() + location.getBlockX();
            Material blockMaterial = chunkAccess.getMaterial(xPosition, yPosition = chunkLocation.getBlockY() + location.getBlockY(), zPosition = chunkLocation.getBlockZ() + location.getBlockZ());
            if (!replaceMaterials.contains(blockMaterial)) continue;
            chunkAccess.setMaterial(material, xPosition, yPosition, zPosition);
        }
    }
}

