/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.oregenerator;

import com.google.common.collect.Sets;
import de.derfrzocker.custom.ore.generator.api.ChunkAccess;
import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.api.OreSettingContainer;
import de.derfrzocker.custom.ore.generator.impl.oregenerator.AbstractOreGenerator;
import de.derfrzocker.custom.ore.generator.utils.NumberUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;

public class RootGenerator
extends AbstractOreGenerator {
    private static final OreSetting ROOT_LENGTH = OreSetting.createOreSetting("ROOT_LENGTH");
    private static final OreSetting CONTINUE_CHANCE = OreSetting.createOreSetting("CONTINUE_CHANCE");
    private static final OreSetting CONTINUE_TRIES = OreSetting.createOreSetting("CONTINUE_TRIES");
    private static final OreSetting MINIMUM_LENGTH_SUBTRACTION = OreSetting.createOreSetting("MINIMUM_LENGTH_SUBTRACTION");
    private static final OreSetting LENGTH_SUBTRACTION_RANGE = OreSetting.createOreSetting("LENGTH_SUBTRACTION_RANGE");
    private static final OreSetting MINIMUM_CHANCE_SUBTRACTION = OreSetting.createOreSetting("MINIMUM_CHANCE_SUBTRACTION");
    private static final OreSetting CHANCE_SUBTRACTION_RANGE = OreSetting.createOreSetting("CHANCE_SUBTRACTION_RANGE");
    private static final OreSetting MINIMUM_TRIES_SUBTRACTION = OreSetting.createOreSetting("MINIMUM_TRIES_SUBTRACTION");
    private static final OreSetting TRIES_SUBTRACTION_RANGE = OreSetting.createOreSetting("TRIES_SUBTRACTION_RANGE");
    private static final OreSetting DOWN_CHANCE = OreSetting.createOreSetting("DOWN_CHANCE");
    private static final Set<OreSetting> NEEDED_ORE_SETTINGS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new OreSetting[]{ROOT_LENGTH, CONTINUE_CHANCE, CONTINUE_TRIES, MINIMUM_LENGTH_SUBTRACTION, LENGTH_SUBTRACTION_RANGE, MINIMUM_CHANCE_SUBTRACTION, CHANCE_SUBTRACTION_RANGE, MINIMUM_TRIES_SUBTRACTION, TRIES_SUBTRACTION_RANGE, DOWN_CHANCE}));
    private static final Map<Integer, BlockFace> DIRECTIONS;

    public RootGenerator(@NotNull Function<String, Info> infoFunction, @NotNull BiFunction<String, OreSetting, Info> oreSettingInfo) {
        super("ROOT_GENERATOR", NEEDED_ORE_SETTINGS, infoFunction, oreSettingInfo);
    }

    @Override
    public void generate(@NotNull OreConfig config, @NotNull ChunkAccess chunkAccess, int x, int z, @NotNull Random random, @NotNull Biome biome, @NotNull Set<Location> locations) {
        Location chunkLocation = new Location(null, (double)(x << 4), 0.0, (double)(z << 4));
        Material material = config.getMaterial();
        Set<Material> replaceMaterials = config.getReplaceMaterials();
        OreSettingContainer oreSettingContainer = config.getOreGeneratorOreSettings();
        int rootLength = NumberUtil.getInt(oreSettingContainer.getValue(ROOT_LENGTH).orElse(0.0), random);
        int continueChance = NumberUtil.getInt(oreSettingContainer.getValue(CONTINUE_CHANCE).orElse(0.0), random);
        int continueTries = NumberUtil.getInt(oreSettingContainer.getValue(CONTINUE_TRIES).orElse(0.0), random);
        int minimumLengthSubtraction = NumberUtil.getInt(oreSettingContainer.getValue(MINIMUM_LENGTH_SUBTRACTION).orElse(0.0), random);
        int lengthSubtractionRange = NumberUtil.getInt(oreSettingContainer.getValue(LENGTH_SUBTRACTION_RANGE).orElse(0.0), random);
        int minimumChanceSubtraction = NumberUtil.getInt(oreSettingContainer.getValue(MINIMUM_CHANCE_SUBTRACTION).orElse(0.0), random);
        int chanceSubtractionRange = NumberUtil.getInt(oreSettingContainer.getValue(CHANCE_SUBTRACTION_RANGE).orElse(0.0), random);
        int minimumTriesSubtraction = NumberUtil.getInt(oreSettingContainer.getValue(MINIMUM_TRIES_SUBTRACTION).orElse(0.0), random);
        int triesSubtractionRange = NumberUtil.getInt(oreSettingContainer.getValue(TRIES_SUBTRACTION_RANGE).orElse(0.0), random);
        int downChance = NumberUtil.getInt(oreSettingContainer.getValue(DOWN_CHANCE).orElse(0.0), random);
        for (Location location : locations) {
            int zPosition;
            int yPosition;
            int xPosition = chunkLocation.getBlockX() + location.getBlockX();
            if (replaceMaterials.contains(chunkAccess.getMaterial(xPosition, yPosition = chunkLocation.getBlockY() + location.getBlockY(), zPosition = chunkLocation.getBlockZ() + location.getBlockZ()))) {
                chunkAccess.setMaterial(material, xPosition, yPosition, zPosition);
            }
            Location startLocation = new Location(null, (double)xPosition, (double)yPosition, (double)zPosition);
            this.generateRoot(material, replaceMaterials, chunkAccess, startLocation, random, continueTries, continueChance, rootLength, minimumTriesSubtraction, triesSubtractionRange, minimumChanceSubtraction, chanceSubtractionRange, minimumLengthSubtraction, lengthSubtractionRange, downChance);
        }
    }

    @Override
    public boolean isSaveValue(@NotNull OreSetting oreSetting, double value, @NotNull OreConfig oreConfig) {
        Validate.notNull((Object)oreSetting, (String)"OreSetting can not be null");
        Validate.notNull((Object)oreConfig, (String)"OreConfig can not be null");
        Validate.isTrue((boolean)NEEDED_ORE_SETTINGS.contains(oreSetting), (String)("The OreGenerator '" + this.getName() + "' does not need the OreSetting '" + oreSetting.getName() + "'"));
        if (oreSetting == ROOT_LENGTH) {
            return value >= 0.0;
        }
        if (oreSetting == CONTINUE_CHANCE) {
            return value >= 0.0 && value <= 100.0;
        }
        if (oreSetting == DOWN_CHANCE) {
            return value >= 0.0 && value <= 100.0;
        }
        if (oreSetting == CONTINUE_TRIES) {
            return value >= 0.0;
        }
        if (oreSetting == LENGTH_SUBTRACTION_RANGE) {
            return value >= 1.0;
        }
        if (oreSetting == CHANCE_SUBTRACTION_RANGE) {
            return value >= 1.0;
        }
        if (oreSetting == TRIES_SUBTRACTION_RANGE) {
            return value >= 1.0;
        }
        return true;
    }

    private void generateRoot(Material setMaterial, Set<Material> replaceMaterials, ChunkAccess chunkAccess, Location startLocation, Random random, int tries, int chance, int length, int triesDeMin, int triesDeRange, int chanceDeMin, int chanceDeRange, int lengthDeMin, int lengthDeRange, int downchance) {
        for (int i = 0; i < tries; ++i) {
            int con = random.nextInt(100);
            if (con >= chance) continue;
            Location newLocation = startLocation.clone();
            int newTries = tries;
            int newchance = chance;
            int newLength = length;
            for (int i2 = 0; i2 < length; ++i2) {
                BlockFace blockFace = DIRECTIONS.get(random.nextInt(DIRECTIONS.size()));
                Location tempNewLocation = newLocation.clone().add((double)blockFace.getModX(), (double)blockFace.getModY(), (double)blockFace.getModZ());
                if (random.nextInt(100) < downchance) {
                    tempNewLocation.add(0.0, -1.0, 0.0);
                }
                if (!replaceMaterials.contains(chunkAccess.getMaterial(tempNewLocation.getBlockX(), tempNewLocation.getBlockY(), tempNewLocation.getBlockZ()))) continue;
                newLocation = tempNewLocation;
                chunkAccess.setMaterial(setMaterial, newLocation.getBlockX(), newLocation.getBlockY(), newLocation.getBlockZ());
                int tempNewTries = newTries - triesDeMin - (triesDeRange <= 0 ? 0 : random.nextInt(triesDeRange));
                int tempNewchance = newchance - chanceDeMin - (chanceDeRange <= 0 ? 0 : random.nextInt(chanceDeRange));
                int tempNewLength = newLength - lengthDeMin - (lengthDeRange <= 0 ? 0 : random.nextInt(lengthDeRange));
                if (tempNewTries <= 0 || tempNewchance <= 0 || tempNewLength <= 0) continue;
                newTries = tempNewTries;
                newchance = tempNewchance;
                newLength = tempNewLength;
                this.generateRoot(setMaterial, replaceMaterials, chunkAccess, newLocation, random, newTries, newchance, newLength, triesDeMin, triesDeRange, chanceDeMin, chanceDeRange, lengthDeMin, lengthDeRange, downchance);
            }
        }
    }

    static {
        HashMap<Integer, BlockFace> blockFaces = new HashMap<Integer, BlockFace>();
        blockFaces.put(0, BlockFace.NORTH);
        blockFaces.put(1, BlockFace.EAST);
        blockFaces.put(2, BlockFace.WEST);
        blockFaces.put(3, BlockFace.SOUTH);
        blockFaces.put(4, BlockFace.NORTH_EAST);
        blockFaces.put(5, BlockFace.NORTH_WEST);
        blockFaces.put(6, BlockFace.SOUTH_WEST);
        blockFaces.put(7, BlockFace.SOUTH_EAST);
        DIRECTIONS = Collections.unmodifiableMap(blockFaces);
    }
}

