/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.oregenerator;

import com.google.common.collect.Sets;
import de.derfrzocker.custom.ore.generator.api.ChunkAccess;
import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.api.OreSettingContainer;
import de.derfrzocker.custom.ore.generator.impl.oregenerator.AbstractOreGenerator;
import de.derfrzocker.custom.ore.generator.utils.NumberUtil;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;

public class GlowStoneGenerator
extends AbstractOreGenerator {
    private static final OreSetting POSITIVE_VERTICAL_SCOPE = OreSetting.createOreSetting("POSITIVE_VERTICAL_SCOPE");
    private static final OreSetting NEGATIVE_VERTICAL_SCOPE = OreSetting.createOreSetting("NEGATIVE_VERTICAL_SCOPE");
    private static final OreSetting HORIZONTAL_SCOPE = OreSetting.createOreSetting("HORIZONTAL_SCOPE");
    private static final OreSetting POSITIVE_TRIES = OreSetting.createOreSetting("POSITIVE_TRIES");
    private static final OreSetting NEGATIVE_TRIES = OreSetting.createOreSetting("NEGATIVE_TRIES");
    private static final OreSetting CONNECTIONS = OreSetting.createOreSetting("CONNECTIONS");
    private static final Set<OreSetting> NEEDED_ORE_SETTINGS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new OreSetting[]{POSITIVE_VERTICAL_SCOPE, NEGATIVE_VERTICAL_SCOPE, HORIZONTAL_SCOPE, POSITIVE_TRIES, NEGATIVE_TRIES, CONNECTIONS}));
    private static final BlockFace[] BLOCK_FACES = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH};

    public GlowStoneGenerator(@NotNull Function<String, Info> infoFunction, @NotNull BiFunction<String, OreSetting, Info> oreSettingInfo) {
        super("GLOW_STONE_GENERATOR", NEEDED_ORE_SETTINGS, infoFunction, oreSettingInfo);
    }

    @Override
    public void generate(@NotNull OreConfig config, @NotNull ChunkAccess chunkAccess, int x, int z, @NotNull Random random, @NotNull Biome biome, @NotNull Set<Location> locations) {
        Location chunkLocation = new Location(null, (double)(x << 4), 0.0, (double)(z << 4));
        Material material = config.getMaterial();
        Set<Material> replaceMaterial = config.getReplaceMaterials();
        OreSettingContainer oreSettingContainer = config.getOreGeneratorOreSettings();
        int positiveVerticalScope = NumberUtil.getInt(oreSettingContainer.getValue(POSITIVE_VERTICAL_SCOPE).orElse(0.0), random);
        int negativeVerticalScope = NumberUtil.getInt(oreSettingContainer.getValue(NEGATIVE_VERTICAL_SCOPE).orElse(12.0), random);
        int horizontalScope = NumberUtil.getInt(oreSettingContainer.getValue(HORIZONTAL_SCOPE).orElse(8.0), random);
        int positiveTries = NumberUtil.getInt(oreSettingContainer.getValue(POSITIVE_TRIES).orElse(0.0), random);
        int negativeTries = NumberUtil.getInt(oreSettingContainer.getValue(NEGATIVE_TRIES).orElse(1500.0), random);
        int connections = NumberUtil.getInt(oreSettingContainer.getValue(CONNECTIONS).orElse(1.0), random);
        for (Location location : locations) {
            int yLocation;
            int trie;
            int xPosition = chunkLocation.getBlockX() + location.getBlockX();
            int yPosition = chunkLocation.getBlockY() + location.getBlockY();
            int zPosition = chunkLocation.getBlockZ() + location.getBlockZ();
            chunkAccess.setMaterial(material, xPosition, yPosition, zPosition);
            for (trie = 0; trie < positiveTries; ++trie) {
                yLocation = yPosition + (positiveVerticalScope == 0 ? 0 : random.nextInt(positiveVerticalScope));
                this.generate(chunkAccess, random, material, replaceMaterial, horizontalScope, connections, xPosition, zPosition, yLocation);
            }
            for (trie = 0; trie < negativeTries; ++trie) {
                yLocation = yPosition - (negativeVerticalScope == 0 ? 0 : random.nextInt(negativeVerticalScope));
                this.generate(chunkAccess, random, material, replaceMaterial, horizontalScope, connections, xPosition, zPosition, yLocation);
            }
        }
    }

    private void generate(@NotNull ChunkAccess chunkAccess, @NotNull Random random, Material material, Set<Material> replaceMaterial, int horizontalScope, int connections, int xPosition, int zPosition, int yLocation) {
        int zLocation;
        int xLocation = xPosition + random.nextInt(horizontalScope) - random.nextInt(horizontalScope);
        if (!replaceMaterial.contains(chunkAccess.getMaterial(xLocation, yLocation, zLocation = zPosition + random.nextInt(horizontalScope) - random.nextInt(horizontalScope)))) {
            return;
        }
        int counter = 0;
        for (BlockFace blockFace : BLOCK_FACES) {
            if (chunkAccess.getMaterial(xLocation + blockFace.getModX(), yLocation + blockFace.getModY(), zLocation + blockFace.getModZ()) == material) {
                ++counter;
            }
            if (counter > connections) break;
        }
        if (connections == 0 && counter == 0) {
            chunkAccess.setMaterial(material, xLocation, yLocation, zLocation);
        } else if (counter <= connections && counter != 0) {
            chunkAccess.setMaterial(material, xLocation, yLocation, zLocation);
        }
    }

    @Override
    public boolean isSaveValue(@NotNull OreSetting oreSetting, double value, @NotNull OreConfig oreConfig) {
        Validate.notNull((Object)oreSetting, (String)"OreSetting can not be null");
        Validate.notNull((Object)oreConfig, (String)"OreConfig can not be null");
        Validate.isTrue((boolean)NEEDED_ORE_SETTINGS.contains(oreSetting), (String)("The OreGenerator '" + this.getName() + "' does not need the OreSetting '" + oreSetting.getName() + "'"));
        if (oreSetting == POSITIVE_VERTICAL_SCOPE) {
            return value >= 1.0;
        }
        if (oreSetting == NEGATIVE_VERTICAL_SCOPE) {
            return value >= 0.0;
        }
        if (oreSetting == HORIZONTAL_SCOPE) {
            return value >= 0.0;
        }
        if (oreSetting == POSITIVE_TRIES) {
            return value >= 0.0;
        }
        if (oreSetting == NEGATIVE_TRIES) {
            return value >= 0.0;
        }
        if (oreSetting == CONNECTIONS) {
            return value >= 1.0;
        }
        throw new RuntimeException("Wtf?");
    }
}

