/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.oregenerator;

import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractOreGenerator
implements OreGenerator {
    @NotNull
    private final String name;
    @NotNull
    private final Set<OreSetting> neededOreSettings;
    @NotNull
    private final Info info;
    @NotNull
    private final Map<OreSetting, Info> oreSettingInfoMap;

    public AbstractOreGenerator(@NotNull String name, @NotNull Set<OreSetting> neededOreSettings, @NotNull Function<String, Info> infoFunction, @NotNull BiFunction<String, OreSetting, Info> oreSettingInfo) {
        Validate.notNull((Object)name, (String)"Name can not be null");
        Validate.notNull(neededOreSettings, (String)"OreSettings can not be null");
        Validate.notNull(infoFunction, (String)"InfoFunction can not be null");
        this.name = name;
        this.neededOreSettings = neededOreSettings;
        this.info = infoFunction.apply(this.getName());
        HashMap oreSettingInfoMap = new HashMap(this.neededOreSettings.size());
        this.neededOreSettings.forEach(oreSetting -> oreSettingInfoMap.put(oreSetting, Objects.requireNonNull((Info)oreSettingInfo.apply(this.name, (OreSetting)oreSetting))));
        this.oreSettingInfoMap = Collections.unmodifiableMap(oreSettingInfoMap);
    }

    @Override
    @NotNull
    public Set<OreSetting> getNeededOreSettings() {
        return this.neededOreSettings;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Info getInfo() {
        return this.info;
    }

    @Override
    @NotNull
    public Info getOreSettingInfo(@NotNull OreSetting oreSetting) {
        Validate.notNull((Object)oreSetting, (String)"OreSetting can not be null");
        Validate.isTrue((boolean)this.getNeededOreSettings().contains(oreSetting), (String)("The OreGenerator '" + this.getName() + "' does not have the OreSetting '" + oreSetting + "'"));
        return this.oreSettingInfoMap.get(oreSetting);
    }
}

