/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.oregenerator;

import com.google.common.collect.Sets;
import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.impl.oregenerator.AbstractOreGenerator;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMinableGenerator
extends AbstractOreGenerator {
    protected static final OreSetting VEIN_SIZE = OreSetting.createOreSetting("VEIN_SIZE");
    private static final Set<OreSetting> NEEDED_ORE_SETTINGS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new OreSetting[]{VEIN_SIZE}));

    public AbstractMinableGenerator(@NotNull Function<String, Info> infoFunction, @NotNull BiFunction<String, OreSetting, Info> oreSettingInfo) {
        super("VANILLA_MINABLE_GENERATOR", NEEDED_ORE_SETTINGS, infoFunction, oreSettingInfo);
    }

    @Override
    public boolean isSaveValue(@NotNull OreSetting oreSetting, double value, @NotNull OreConfig oreConfig) {
        Validate.notNull((Object)oreSetting, (String)"OreSetting can not be null");
        Validate.notNull((Object)oreConfig, (String)"OreConfig can not be null");
        Validate.isTrue((boolean)this.getNeededOreSettings().contains(oreSetting), (String)("The OreGenerator '" + this.getName() + "' does not need the OreSetting '" + oreSetting.getName() + "'"));
        return value >= 0.0;
    }
}

