/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.dao;

import de.derfrzocker.custom.ore.generator.api.WorldConfig;
import de.derfrzocker.custom.ore.generator.api.dao.WorldConfigDao;
import de.derfrzocker.custom.ore.generator.impl.dao.LazyWorldConfigCache;
import de.derfrzocker.custom.ore.generator.utils.ReloadAble;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class WorldConfigYamlDao
implements WorldConfigDao,
ReloadAble {
    private final Map<String, LazyWorldConfigCache> lazyWorldConfigCacheMap = new HashMap<String, LazyWorldConfigCache>();
    @NotNull
    private final File directory;

    public WorldConfigYamlDao(@NotNull File directory) {
        Validate.notNull((Object)directory, (String)"Directory can not be null");
        if (directory.exists()) {
            Validate.isTrue((boolean)directory.isDirectory(), (String)"Directory is not a directory?");
        }
        this.directory = directory;
        RELOAD_ABLES.add(this);
    }

    public void init() {
        this.reload();
    }

    @Override
    public Optional<WorldConfig> get(@NotNull String key) {
        Validate.notNull((Object)key, (String)"Key can not be null");
        Validate.notEmpty((String)key, (String)"Key can not be empty");
        LazyWorldConfigCache lazyWorldConfigCache = this.lazyWorldConfigCacheMap.get(key);
        if (lazyWorldConfigCache != null) {
            return Optional.of(lazyWorldConfigCache.getWorldConfig());
        }
        File file = new File(this.directory, key + ".yml");
        if (!file.exists() || !file.isFile()) {
            return Optional.empty();
        }
        LazyWorldConfigCache lazyWorldConfigCache1 = new LazyWorldConfigCache(file);
        this.lazyWorldConfigCacheMap.put(key, lazyWorldConfigCache1);
        return Optional.of(lazyWorldConfigCache1.getWorldConfig());
    }

    @Override
    public void remove(@NotNull WorldConfig value) {
        Validate.notNull((Object)value, (String)"WorldConfig can not be null");
        this.lazyWorldConfigCacheMap.remove(value.getName());
        new File(this.directory, value.getName() + ".yml").delete();
    }

    @Override
    public void save(@NotNull WorldConfig value) {
        Validate.notNull((Object)value, (String)"WorldConfig can not be null");
        LazyWorldConfigCache lazyWorldConfigCache = this.lazyWorldConfigCacheMap.get(value.getName());
        if (lazyWorldConfigCache == null) {
            lazyWorldConfigCache = new LazyWorldConfigCache(new File(this.directory, value.getName() + ".yml"));
            this.lazyWorldConfigCacheMap.put(value.getName(), lazyWorldConfigCache);
        }
        lazyWorldConfigCache.setWorldConfig(value);
        lazyWorldConfigCache.save();
    }

    @Override
    public Set<WorldConfig> getAll() {
        LinkedHashSet<WorldConfig> worldConfigs = new LinkedHashSet<WorldConfig>();
        this.lazyWorldConfigCacheMap.forEach((name, lazyWorldConfigCache) -> worldConfigs.add(lazyWorldConfigCache.getWorldConfig()));
        return worldConfigs;
    }

    @Override
    public void reload() {
        this.lazyWorldConfigCacheMap.clear();
        File[] files = this.directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            this.lazyWorldConfigCacheMap.put(file.getName().substring(0, file.getName().length() - 4), new LazyWorldConfigCache(file));
        }
    }
}

