/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.dao;

import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.dao.OreConfigDao;
import de.derfrzocker.custom.ore.generator.impl.dao.LazyOreConfigCache;
import de.derfrzocker.custom.ore.generator.utils.ReloadAble;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class OreConfigYamlDao
implements OreConfigDao,
ReloadAble {
    private final Map<String, LazyOreConfigCache> lazyOreConfigCacheMap = new HashMap<String, LazyOreConfigCache>();
    @NotNull
    private final File directory;

    public OreConfigYamlDao(@NotNull File directory) {
        Validate.notNull((Object)directory, (String)"Directory can not be null");
        if (directory.exists()) {
            Validate.isTrue((boolean)directory.isDirectory(), (String)"Directory is not a directory?");
        }
        this.directory = directory;
        RELOAD_ABLES.add(this);
    }

    public void init() {
        this.reload();
    }

    @Override
    @NotNull
    public Optional<OreConfig> get(@NotNull String key) {
        Validate.notNull((Object)key, (String)"Key can not be null");
        Validate.notEmpty((String)key, (String)"Key can not be empty");
        LazyOreConfigCache lazyOreConfigCache = this.lazyOreConfigCacheMap.get(key);
        if (lazyOreConfigCache != null) {
            return Optional.of(lazyOreConfigCache.getOreConfig());
        }
        File file = new File(this.directory, key + ".yml");
        if (!file.exists() || !file.isFile()) {
            return Optional.empty();
        }
        LazyOreConfigCache lazyOreConfigCache1 = new LazyOreConfigCache(file);
        this.lazyOreConfigCacheMap.put(key, lazyOreConfigCache1);
        return Optional.of(lazyOreConfigCache1.getOreConfig());
    }

    @Override
    public void remove(@NotNull OreConfig value) {
        Validate.notNull((Object)value, (String)"OreConfig can not be null");
        this.lazyOreConfigCacheMap.remove(value.getName());
        new File(this.directory, value.getName() + ".yml").delete();
    }

    @Override
    public void save(@NotNull OreConfig value) {
        Validate.notNull((Object)value, (String)"OreConfig can not be null");
        LazyOreConfigCache lazyOreConfigCache = this.lazyOreConfigCacheMap.get(value.getName());
        if (lazyOreConfigCache == null) {
            lazyOreConfigCache = new LazyOreConfigCache(new File(this.directory, value.getName() + ".yml"));
            this.lazyOreConfigCacheMap.put(value.getName(), lazyOreConfigCache);
        }
        lazyOreConfigCache.setOreConfig(value);
        lazyOreConfigCache.save();
    }

    @Override
    public Set<OreConfig> getAll() {
        LinkedHashSet<OreConfig> oreConfigs = new LinkedHashSet<OreConfig>();
        this.lazyOreConfigCacheMap.forEach((name, lazyOreConfigCache) -> oreConfigs.add(lazyOreConfigCache.getOreConfig()));
        return oreConfigs;
    }

    @Override
    public void reload() {
        this.lazyOreConfigCacheMap.clear();
        File[] files = this.directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            this.lazyOreConfigCacheMap.put(file.getName().substring(0, file.getName().length() - 4), new LazyOreConfigCache(file));
        }
    }
}

