/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.dao;

import de.derfrzocker.custom.ore.generator.api.WorldConfig;
import de.derfrzocker.custom.ore.generator.impl.WorldConfigYamlImpl;
import de.derfrzocker.custom.ore.generator.utils.Config;
import de.derfrzocker.custom.ore.generator.utils.ReloadAble;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyWorldConfigCache
implements ReloadAble {
    private final Object look = new Object();
    @NotNull
    private final File file;
    @Nullable
    private WorldConfig worldConfig;

    public LazyWorldConfigCache(@NotNull File file) {
        Validate.notNull((Object)file, (String)"File can not be null");
        Validate.isTrue((boolean)file.getName().endsWith(".yml"), (String)("File " + file + " has not valid extension, must be '.yml'"));
        if (file.exists()) {
            Validate.isTrue((boolean)file.isFile(), (String)("File " + file + " is not a File?"));
        }
        this.file = file;
    }

    public void save() {
        WorldConfig worldConfig;
        if (this.worldConfig == null) {
            return;
        }
        if (!(this.worldConfig instanceof ConfigurationSerializable)) {
            worldConfig = new WorldConfigYamlImpl(this.worldConfig.getName());
            WorldConfigYamlImpl.copyData(this.worldConfig, (WorldConfigYamlImpl)worldConfig);
        } else {
            worldConfig = this.worldConfig;
        }
        Config config = new Config(this.file);
        config.set("value", worldConfig);
        try {
            config.options().header("Only edit this file if you 10000% sure you know what you are doing. \nYou can set everything via the plugin commands, no need to edit this file manully.").copyHeader(true);
            config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error while saving WorldOreConfig " + worldConfig.getName() + " to disk!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public WorldConfig getWorldConfig() {
        if (this.worldConfig != null) {
            return this.worldConfig;
        }
        Object object = this.look;
        synchronized (object) {
            if (this.worldConfig != null) {
                return this.worldConfig;
            }
            if (!this.file.exists()) {
                throw new RuntimeException("File " + this.file + " does not exists, can not load WorldConfig from none existing file");
            }
            Config config = new Config(this.file);
            Object object2 = config.get("value");
            if (!(object2 instanceof WorldConfig)) {
                throw new RuntimeException("File " + this.file + " does not have a WorldConfig under the key 'value'");
            }
            WorldConfig worldConfig = (WorldConfig)object2;
            if (!worldConfig.getName().equals(this.file.getName().substring(0, this.file.getName().length() - 4))) {
                throw new RuntimeException("File name " + this.file.getName() + " and WorldConfig name " + worldConfig.getName() + " does not match");
            }
            this.worldConfig = worldConfig;
        }
        return this.worldConfig;
    }

    public void setWorldConfig(@NotNull WorldConfig worldConfig) {
        Validate.notNull((Object)worldConfig, (String)"worldConfig can not be null");
        if (!worldConfig.getName().equals(this.file.getName().substring(0, this.file.getName().length() - 4))) {
            throw new RuntimeException("File name " + this.file.getName() + " and WorldConfig name " + worldConfig.getName() + " does not match");
        }
        this.worldConfig = worldConfig;
    }

    @Override
    public void reload() {
        this.worldConfig = null;
    }
}

