/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.dao;

import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.impl.OreConfigYamlImpl;
import de.derfrzocker.custom.ore.generator.utils.Config;
import de.derfrzocker.custom.ore.generator.utils.ReloadAble;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyOreConfigCache
implements ReloadAble {
    private final Object look = new Object();
    @NotNull
    private final File file;
    @Nullable
    private OreConfig oreConfig;

    public LazyOreConfigCache(@NotNull File file) {
        Validate.notNull((Object)file, (String)"File can not be null");
        Validate.isTrue((boolean)file.getName().endsWith(".yml"), (String)("File " + file + " has not valid extension, must be '.yml'"));
        if (file.exists()) {
            Validate.isTrue((boolean)file.isFile(), (String)("File " + file + " is not a File?"));
        }
        this.file = file;
    }

    public void save() {
        OreConfig oreConfig;
        if (this.oreConfig == null) {
            return;
        }
        if (!(this.oreConfig instanceof ConfigurationSerializable)) {
            oreConfig = new OreConfigYamlImpl(this.oreConfig.getName(), this.oreConfig.getMaterial(), this.oreConfig.getOreGenerator(), this.oreConfig.getBlockSelector());
            OreConfigYamlImpl.copyData(this.oreConfig, (OreConfigYamlImpl)oreConfig);
        } else {
            oreConfig = this.oreConfig;
        }
        Config config = new Config(this.file);
        config.set("value", oreConfig);
        try {
            config.options().header("Only edit this file if you 10000% sure you know what you are doing. \nYou can set everything via the plugin commands, no need to edit this file manully.").copyHeader(true);
            config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error while saving OreConfig " + oreConfig.getName() + " to disk!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public OreConfig getOreConfig() {
        if (this.oreConfig != null) {
            return this.oreConfig;
        }
        Object object = this.look;
        synchronized (object) {
            if (this.oreConfig != null) {
                return this.oreConfig;
            }
            if (!this.file.exists()) {
                throw new RuntimeException("File " + this.file + " does not exists, can not load OreConfig from none existing file");
            }
            Config config = new Config(this.file);
            Object object2 = config.get("value");
            if (!(object2 instanceof OreConfig)) {
                throw new RuntimeException("File " + this.file + " does not have a OreConfig under the key 'value'");
            }
            OreConfig oreConfig = (OreConfig)object2;
            if (!oreConfig.getName().equals(this.file.getName().substring(0, this.file.getName().length() - 4))) {
                throw new RuntimeException("File name " + this.file.getName() + " and OreConfig name " + oreConfig.getName() + " does not match");
            }
            this.oreConfig = oreConfig;
        }
        return this.oreConfig;
    }

    public void setOreConfig(@NotNull OreConfig oreConfig) {
        Validate.notNull((Object)oreConfig, (String)"OreConfig can not be null");
        if (!oreConfig.getName().equals(this.file.getName().substring(0, this.file.getName().length() - 4))) {
            throw new RuntimeException("File name " + this.file.getName() + " and OreConfig name " + oreConfig.getName() + " does not match");
        }
        this.oreConfig = oreConfig;
    }

    @Override
    public void reload() {
        this.oreConfig = null;
    }
}

