/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.customdata;

import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataApplier;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataType;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractCustomData;
import de.derfrzocker.custom.ore.generator.impl.v1_14_R1.customdata.OraxenApplier_v1_14_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_15_R1.customdata.OraxenApplier_v1_15_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R1.customdata.OraxenApplier_v1_16_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R2.customdata.OraxenApplier_v1_16_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R3.customdata.OraxenApplier_v1_16_R3;
import de.derfrzocker.custom.ore.generator.impl.v1_17_R1.customdata.OraxenApplier_v1_17_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_18_R1.customdata.OraxenApplier_v1_18_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_18_R2.customdata.OraxenApplier_v1_18_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R1.customdata.OraxenApplier_v1_19_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R2.customdata.OraxenApplier_v1_19_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R3.customdata.OraxenApplier_v1_19_R3;
import de.derfrzocker.custom.ore.generator.utils.Version;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanicFactory;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.type.NoteBlock;
import org.bukkit.block.data.type.Tripwire;
import org.jetbrains.annotations.NotNull;

public class OraxenCustomData
extends AbstractCustomData<CustomDataApplier> {
    public OraxenCustomData(@NotNull Function<String, Info> infoFunction) {
        super("ORAXEN", CustomDataType.STRING, infoFunction);
    }

    @Override
    public boolean canApply(@NotNull OreConfig oreConfig) {
        return oreConfig.getMaterial() == Material.MUSHROOM_STEM;
    }

    @Override
    public boolean isValidCustomData(@NotNull Object customData, @NotNull OreConfig oreConfig) {
        if (!(customData instanceof String)) {
            return false;
        }
        String name = (String)customData;
        return OraxenItems.exists((String)name);
    }

    @Override
    @NotNull
    public Object normalize(@NotNull Object customData, @NotNull OreConfig oreConfig) {
        return customData;
    }

    @Override
    public boolean hasCustomData(@NotNull BlockState blockState) {
        BlockData blockData = blockState.getBlockData();
        if (blockState.getType() == Material.MUSHROOM_STEM) {
            return BlockMechanicFactory.getBlockMechanic((int)this.getCode((MultipleFacing)blockData)) != null;
        }
        if (blockState.getType() == Material.NOTE_BLOCK) {
            NoteBlock noteBlock = (NoteBlock)blockData;
            return NoteBlockMechanicFactory.getBlockMechanic((int)(noteBlock.getInstrument().getType() * 25 + noteBlock.getNote().getId() + (noteBlock.isPowered() ? 400 : 0) - 26)) != null;
        }
        if (blockState.getType() == Material.TRIPWIRE) {
            return StringBlockMechanicFactory.getBlockMechanic((int)StringBlockMechanicFactory.getCode((Tripwire)((Tripwire)blockData))) != null;
        }
        return false;
    }

    @Override
    @NotNull
    public Object getCustomData(@NotNull BlockState blockState) {
        BlockData blockData = blockState.getBlockData();
        if (blockState.getType() == Material.MUSHROOM_STEM) {
            return BlockMechanicFactory.getBlockMechanic((int)this.getCode((MultipleFacing)blockData)).getItemID();
        }
        if (blockState.getType() == Material.NOTE_BLOCK) {
            NoteBlock noteBlock = (NoteBlock)blockData;
            return NoteBlockMechanicFactory.getBlockMechanic((int)(noteBlock.getInstrument().getType() * 25 + noteBlock.getNote().getId() + (noteBlock.isPowered() ? 400 : 0) - 26)).getItemID();
        }
        if (blockState.getType() == Material.TRIPWIRE) {
            return StringBlockMechanicFactory.getBlockMechanic((int)StringBlockMechanicFactory.getCode((Tripwire)((Tripwire)blockData))).getItemID();
        }
        return false;
    }

    private int getCode(MultipleFacing blockData) {
        int sum = 0;
        List<BlockFace> properties = Arrays.asList(BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH, BlockFace.DOWN, BlockFace.UP);
        for (BlockFace blockFace : blockData.getFaces()) {
            sum = (int)((double)sum + Math.pow(2.0, properties.indexOf(blockFace)));
        }
        return sum;
    }

    @Override
    @NotNull
    protected CustomDataApplier getCustomDataApplier0() {
        switch (Version.getServerVersion(Bukkit.getServer())) {
            case v1_19_R3: {
                return new OraxenApplier_v1_19_R3(this);
            }
            case v1_19_R2: {
                return new OraxenApplier_v1_19_R2(this);
            }
            case v1_19_R1: {
                return new OraxenApplier_v1_19_R1(this);
            }
            case v1_18_R2: {
                return new OraxenApplier_v1_18_R2(this);
            }
            case v1_18_R1: {
                return new OraxenApplier_v1_18_R1(this);
            }
            case v1_17_R1: {
                return new OraxenApplier_v1_17_R1(this);
            }
            case v1_16_R3: {
                return new OraxenApplier_v1_16_R3(this);
            }
            case v1_16_R2: {
                return new OraxenApplier_v1_16_R2(this);
            }
            case v1_16_R1: {
                return new OraxenApplier_v1_16_R1(this);
            }
            case v1_15_R1: {
                return new OraxenApplier_v1_15_R1(this);
            }
            case v1_14_R1: {
                return new OraxenApplier_v1_14_R1(this);
            }
        }
        throw new UnsupportedOperationException("Version not supported jet!");
    }
}

