/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.customdata;

import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataApplier;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataType;
import de.derfrzocker.custom.ore.generator.api.customdata.LimitedValuesCustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractCustomData;
import de.derfrzocker.custom.ore.generator.impl.v1_14_R1.customdata.ItemModsApplier_v1_14_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_15_R1.customdata.ItemModsApplier_v1_15_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R1.customdata.ItemModsApplier_v1_16_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R2.customdata.ItemModsApplier_v1_16_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R3.customdata.ItemModsApplier_v1_16_R3;
import de.derfrzocker.custom.ore.generator.impl.v1_17_R1.customdata.ItemModsApplier_v1_17_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_18_R1.customdata.ItemModsApplier_v1_18_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_18_R2.customdata.ItemModsApplier_v1_18_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R1.customdata.ItemModsApplier_v1_19_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R2.customdata.ItemModsApplier_v1_19_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R3.customdata.ItemModsApplier_v1_19_R3;
import de.derfrzocker.custom.ore.generator.utils.Version;
import dev.linwood.itemmods.ItemMods;
import dev.linwood.itemmods.api.block.CustomBlock;
import dev.linwood.itemmods.pack.ItemModsPack;
import dev.linwood.itemmods.pack.PackManager;
import dev.linwood.itemmods.pack.PackObject;
import dev.linwood.itemmods.pack.asset.BlockAsset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.jetbrains.annotations.NotNull;

public class ItemModsCustomData
extends AbstractCustomData<CustomDataApplier>
implements LimitedValuesCustomData {
    public ItemModsCustomData(@NotNull Function<String, Info> infoFunction) {
        super("ITEM_MODS", CustomDataType.STRING, infoFunction);
    }

    @Override
    public boolean canApply(@NotNull OreConfig oreConfig) {
        return oreConfig.getMaterial() == Material.SPAWNER;
    }

    @Override
    public boolean isValidCustomData(@NotNull Object customData, @NotNull OreConfig oreConfig) {
        if (!(customData instanceof String)) {
            return false;
        }
        if (oreConfig.getMaterial() != Material.SPAWNER) {
            return false;
        }
        return new PackObject((String)customData).getBlock() != null;
    }

    @Override
    @NotNull
    public Object normalize(@NotNull Object customData, @NotNull OreConfig oreConfig) {
        return customData;
    }

    @Override
    public boolean hasCustomData(@NotNull BlockState blockState) {
        Validate.notNull((Object)blockState, (String)"BlockState can not be null");
        return new CustomBlock(blockState.getLocation()).getConfig() != null;
    }

    @Override
    @NotNull
    public String getCustomData(@NotNull BlockState blockState) {
        Validate.isTrue((boolean)this.hasCustomData(blockState), (String)("The given BlockState '" + blockState.getType() + ", " + blockState.getLocation() + "' can not have the CustomData '" + this.getName() + "'"));
        return new CustomBlock(blockState.getLocation()).getPackObject().toString();
    }

    @Override
    @NotNull
    protected CustomDataApplier getCustomDataApplier0() {
        switch (Version.getServerVersion(Bukkit.getServer())) {
            case v1_19_R3: {
                return new ItemModsApplier_v1_19_R3(this);
            }
            case v1_19_R2: {
                return new ItemModsApplier_v1_19_R2(this);
            }
            case v1_19_R1: {
                return new ItemModsApplier_v1_19_R1(this);
            }
            case v1_18_R2: {
                return new ItemModsApplier_v1_18_R2(this);
            }
            case v1_18_R1: {
                return new ItemModsApplier_v1_18_R1(this);
            }
            case v1_17_R1: {
                return new ItemModsApplier_v1_17_R1(this);
            }
            case v1_16_R3: {
                return new ItemModsApplier_v1_16_R3(this);
            }
            case v1_16_R2: {
                return new ItemModsApplier_v1_16_R2(this);
            }
            case v1_16_R1: {
                return new ItemModsApplier_v1_16_R1(this);
            }
            case v1_15_R1: {
                return new ItemModsApplier_v1_15_R1(this);
            }
            case v1_14_R1: {
                return new ItemModsApplier_v1_14_R1(this);
            }
        }
        throw new UnsupportedOperationException("Version not supported jet!");
    }

    @Override
    @NotNull
    public Set<Object> getPossibleValues(@NotNull Material material) {
        Validate.notNull((Object)material, (String)"Material can not be null");
        if (material != Material.SPAWNER) {
            return new HashSet<Object>();
        }
        PackManager packManager = ItemMods.getPackManager();
        HashSet<String> set = new HashSet<String>();
        for (ItemModsPack pack : packManager.getPacks()) {
            for (BlockAsset blockAsset : pack.getBlocks()) {
                set.add(pack.getName() + ":" + blockAsset.getName());
            }
        }
        return Collections.unmodifiableSet(set);
    }
}

