/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.customdata;

import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataApplier;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataType;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractCustomData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileReadAbleCustomData<T extends CustomDataApplier>
extends AbstractCustomData<T> {
    @NotNull
    private final File fileFolder;

    public FileReadAbleCustomData(@NotNull String name, @NotNull Function<String, Info> infoFunction, @NotNull File fileFolder) {
        super(name, CustomDataType.STRING, infoFunction);
        Validate.notNull((Object)fileFolder, (String)"File folder can not be null");
        if (!fileFolder.exists() && !fileFolder.mkdirs()) {
            throw new RuntimeException("Can not create folder " + fileFolder);
        }
        Validate.isTrue((boolean)fileFolder.isDirectory(), (String)"File folder is not a directory");
        this.fileFolder = fileFolder;
    }

    @Override
    @NotNull
    public final CustomDataType getCustomDataType() {
        return CustomDataType.STRING;
    }

    @Override
    public final boolean isValidCustomData(@NotNull Object customData, @NotNull OreConfig oreConfig) {
        if (!(customData instanceof String)) {
            return false;
        }
        String data = (String)customData;
        if (data.startsWith("file:")) {
            String readData = this.getDataFromFile(data);
            if (readData == null) {
                return false;
            }
            return this.isValidCustomData0(readData, oreConfig);
        }
        return this.isValidCustomData0(data, oreConfig);
    }

    @Override
    @NotNull
    public final String normalize(@NotNull Object customData, @NotNull OreConfig oreConfig) {
        String data = (String)customData;
        if (!data.startsWith("file:")) {
            return this.normalize0(data, oreConfig);
        }
        String newData = this.getDataFromFile(data);
        if (newData == null) {
            throw new RuntimeException("Returned Data for " + data + " is null");
        }
        return this.normalize0(newData, oreConfig);
    }

    protected abstract boolean isValidCustomData0(@NotNull String var1, @NotNull OreConfig var2);

    protected String normalize0(@NotNull String customData, @NotNull OreConfig oreConfig) {
        return customData;
    }

    @Nullable
    private String getDataFromFile(@NotNull String data) {
        File file = new File(this.fileFolder, data.replace("file:", ""));
        if (!file.isFile()) {
            return null;
        }
        if (!this.isSubDirectory(file)) {
            return null;
        }
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(file.toURI()));
            return new String(encoded);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error while reading String from " + data, e);
        }
    }

    private boolean isSubDirectory(@NotNull File file) {
        File baseFolder;
        try {
            baseFolder = this.fileFolder.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        for (File folder = file.getCanonicalFile().getParentFile(); folder != null; folder = folder.getParentFile()) {
            if (!baseFolder.equals(folder)) continue;
            return true;
        }
        return false;
    }
}

