/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.customdata;

import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataApplier;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataType;
import de.derfrzocker.custom.ore.generator.api.customdata.LimitedValuesCustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractCustomData;
import de.derfrzocker.custom.ore.generator.impl.v1_13_R1.customdata.FacingApplier_v1_13_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_13_R2.customdata.FacingApplier_v1_13_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_14_R1.customdata.FacingApplier_v1_14_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_15_R1.customdata.FacingApplier_v1_15_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R1.customdata.FacingApplier_v1_16_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R2.customdata.FacingApplier_v1_16_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R3.customdata.FacingApplier_v1_16_R3;
import de.derfrzocker.custom.ore.generator.impl.v1_17_R1.customdata.FacingApplier_v1_17_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_18_R1.customdata.FacingApplier_v1_18_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_18_R2.customdata.FacingApplier_v1_18_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R1.customdata.FacingApplier_v1_19_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R2.customdata.FacingApplier_v1_19_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R3.customdata.FacingApplier_v1_19_R3;
import de.derfrzocker.custom.ore.generator.utils.Version;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.jetbrains.annotations.NotNull;

public class FacingCustomData
extends AbstractCustomData<CustomDataApplier>
implements LimitedValuesCustomData {
    public FacingCustomData(@NotNull Function<String, Info> infoFunction) {
        super("FACING", CustomDataType.STRING, infoFunction);
    }

    @Override
    public boolean canApply(@NotNull OreConfig oreConfig) {
        return Bukkit.createBlockData((Material)oreConfig.getMaterial()) instanceof Directional;
    }

    @Override
    public boolean isValidCustomData(@NotNull Object customData, @NotNull OreConfig oreConfig) {
        if (!(customData instanceof String)) {
            return false;
        }
        try {
            BlockFace blockFace = BlockFace.valueOf((String)((String)customData).toUpperCase());
            return ((Directional)Bukkit.createBlockData((Material)oreConfig.getMaterial())).getFaces().contains(blockFace);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    @NotNull
    public Object normalize(@NotNull Object customData, @NotNull OreConfig oreConfig) {
        return customData;
    }

    @Override
    public boolean hasCustomData(@NotNull BlockState blockState) {
        Validate.notNull((Object)blockState, (String)"BlockState can not be null");
        return blockState.getBlockData() instanceof Directional;
    }

    @NotNull
    public BlockFace getCustomData(@NotNull BlockState blockState) {
        Validate.isTrue((boolean)this.hasCustomData(blockState), (String)("The given BlockState '" + blockState.getType() + ", " + blockState.getLocation() + "' can not have the CustomData '" + this.getName() + "'"));
        Directional directional = (Directional)blockState.getBlockData();
        return directional.getFacing();
    }

    @Override
    @NotNull
    protected CustomDataApplier getCustomDataApplier0() {
        switch (Version.getServerVersion(Bukkit.getServer())) {
            case v1_19_R3: {
                return new FacingApplier_v1_19_R3(this);
            }
            case v1_19_R2: {
                return new FacingApplier_v1_19_R2(this);
            }
            case v1_19_R1: {
                return new FacingApplier_v1_19_R1(this);
            }
            case v1_18_R2: {
                return new FacingApplier_v1_18_R2(this);
            }
            case v1_18_R1: {
                return new FacingApplier_v1_18_R1(this);
            }
            case v1_17_R1: {
                return new FacingApplier_v1_17_R1(this);
            }
            case v1_16_R3: {
                return new FacingApplier_v1_16_R3(this);
            }
            case v1_16_R2: {
                return new FacingApplier_v1_16_R2(this);
            }
            case v1_16_R1: {
                return new FacingApplier_v1_16_R1(this);
            }
            case v1_15_R1: {
                return new FacingApplier_v1_15_R1(this);
            }
            case v1_14_R1: {
                return new FacingApplier_v1_14_R1(this);
            }
            case v1_13_R2: {
                return new FacingApplier_v1_13_R2(this);
            }
            case v1_13_R1: {
                return new FacingApplier_v1_13_R1(this);
            }
        }
        throw new UnsupportedOperationException("Version not supported jet!");
    }

    @Override
    @NotNull
    public Set<Object> getPossibleValues(@NotNull Material material) {
        Validate.notNull((Object)material, (String)"Material can not be null");
        BlockData blockData = material.createBlockData();
        Validate.isTrue((boolean)(material.createBlockData() instanceof Directional), (String)("The given Material '" + material + "' can not have the CustomData '" + this.getName() + "'"));
        HashSet set = new HashSet();
        ((Directional)blockData).getFaces().forEach(blockFace -> set.add(blockFace.name()));
        return Collections.unmodifiableSet(set);
    }
}

