/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.customdata;

import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataApplier;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataType;
import de.derfrzocker.custom.ore.generator.api.customdata.LimitedValuesCustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractCustomData;
import de.derfrzocker.custom.ore.generator.impl.v1_13_R1.customdata.DirectionApplier_v1_13_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_13_R2.customdata.DirectionApplier_v1_13_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_14_R1.customdata.DirectionApplier_v1_14_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_15_R1.customdata.DirectionApplier_v1_15_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R1.customdata.DirectionApplier_v1_16_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R2.customdata.DirectionApplier_v1_16_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R3.customdata.DirectionApplier_v1_16_R3;
import de.derfrzocker.custom.ore.generator.impl.v1_17_R1.customdata.DirectionApplier_v1_17_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_18_R1.customdata.DirectionApplier_v1_18_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_18_R2.customdata.DirectionApplier_v1_18_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R1.customdata.DirectionApplier_v1_19_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R2.customdata.DirectionApplier_v1_19_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R3.customdata.DirectionApplier_v1_19_R3;
import de.derfrzocker.custom.ore.generator.utils.Version;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.jetbrains.annotations.NotNull;

public class DirectionCustomData
extends AbstractCustomData<CustomDataApplier>
implements LimitedValuesCustomData {
    @NotNull
    private final BlockFace blockFace;

    public DirectionCustomData(@NotNull BlockFace blockFace, @NotNull Function<String, Info> infoFunction) {
        super(blockFace.name(), CustomDataType.BOOLEAN, infoFunction);
        this.blockFace = blockFace;
    }

    @Override
    public boolean canApply(@NotNull OreConfig oreConfig) {
        BlockData blockData = Bukkit.createBlockData((Material)oreConfig.getMaterial());
        if (!(blockData instanceof MultipleFacing)) {
            return false;
        }
        return ((MultipleFacing)blockData).getAllowedFaces().contains(this.blockFace);
    }

    @Override
    public boolean isValidCustomData(@NotNull Object customData, @NotNull OreConfig oreConfig) {
        return customData instanceof Boolean;
    }

    @Override
    @NotNull
    public Object normalize(@NotNull Object customData, @NotNull OreConfig oreConfig) {
        return customData;
    }

    @Override
    public boolean hasCustomData(@NotNull BlockState blockState) {
        Validate.notNull((Object)blockState, (String)"BlockState can not be null");
        BlockData blockData = blockState.getBlockData();
        if (!(blockData instanceof MultipleFacing)) {
            return false;
        }
        MultipleFacing multipleFacing = (MultipleFacing)blockData;
        return multipleFacing.getAllowedFaces().contains(this.blockFace);
    }

    @Override
    @NotNull
    public Boolean getCustomData(@NotNull BlockState blockState) {
        Validate.isTrue((boolean)this.hasCustomData(blockState), (String)("The given BlockState '" + blockState.getType() + ", " + blockState.getLocation() + "' can not have the CustomData '" + this.getName() + "'"));
        MultipleFacing multipleFacing = (MultipleFacing)blockState.getBlockData();
        return multipleFacing.hasFace(this.blockFace);
    }

    @Override
    @NotNull
    protected CustomDataApplier getCustomDataApplier0() {
        switch (Version.getServerVersion(Bukkit.getServer())) {
            case v1_19_R3: {
                return new DirectionApplier_v1_19_R3(this, this.blockFace);
            }
            case v1_19_R2: {
                return new DirectionApplier_v1_19_R2(this, this.blockFace);
            }
            case v1_19_R1: {
                return new DirectionApplier_v1_19_R1(this, this.blockFace);
            }
            case v1_18_R2: {
                return new DirectionApplier_v1_18_R2(this, this.blockFace);
            }
            case v1_18_R1: {
                return new DirectionApplier_v1_18_R1(this, this.blockFace);
            }
            case v1_17_R1: {
                return new DirectionApplier_v1_17_R1(this, this.blockFace);
            }
            case v1_16_R3: {
                return new DirectionApplier_v1_16_R3(this, this.blockFace);
            }
            case v1_16_R2: {
                return new DirectionApplier_v1_16_R2(this, this.blockFace);
            }
            case v1_16_R1: {
                return new DirectionApplier_v1_16_R1(this, this.blockFace);
            }
            case v1_15_R1: {
                return new DirectionApplier_v1_15_R1(this, this.blockFace);
            }
            case v1_14_R1: {
                return new DirectionApplier_v1_14_R1(this, this.blockFace);
            }
            case v1_13_R2: {
                return new DirectionApplier_v1_13_R2(this, this.blockFace);
            }
            case v1_13_R1: {
                return new DirectionApplier_v1_13_R1(this, this.blockFace);
            }
        }
        throw new UnsupportedOperationException("Version not supported jet!");
    }

    @Override
    @NotNull
    public Set<Object> getPossibleValues(@NotNull Material material) {
        return BOOLEAN_VALUE;
    }
}

