/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.customdata;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataApplier;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataType;
import de.derfrzocker.custom.ore.generator.impl.customdata.AbstractCustomData;
import java.util.Base64;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSkullTextureCustomData
extends AbstractCustomData<SkullTextureApplier> {
    public AbstractSkullTextureCustomData(@NotNull Function<String, Info> infoFunction) {
        super("SKULL_TEXTURE", CustomDataType.STRING, infoFunction);
    }

    @Override
    public boolean isValidCustomData(@NotNull Object customData, @NotNull OreConfig oreConfig) {
        if (!(customData instanceof String)) {
            return false;
        }
        try {
            JsonElement jsonElement = new JsonParser().parse(new String(Base64.getDecoder().decode((String)customData)));
            return jsonElement.getAsJsonObject().get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").getAsString().contains("minecraft.net");
        }
        catch (JsonParseException | IllegalArgumentException | IllegalStateException | NullPointerException e) {
            return false;
        }
    }

    @Override
    @NotNull
    public Object normalize(@NotNull Object customData, @NotNull OreConfig oreConfig) {
        return customData;
    }

    @Override
    public boolean hasCustomData(@NotNull BlockState blockState) {
        Validate.notNull((Object)blockState, (String)"BlockState can not be null");
        if (!(blockState instanceof Skull)) {
            return false;
        }
        return ((SkullTextureApplier)this.getCustomDataApplier()).hasCustomData((Skull)blockState);
    }

    @Override
    @NotNull
    public String getCustomData(@NotNull BlockState blockState) {
        Validate.isTrue((boolean)this.hasCustomData(blockState), (String)("The given BlockState '" + blockState.getType() + ", " + blockState.getLocation() + "' can not have the CustomData '" + this.getName() + "'"));
        return ((SkullTextureApplier)this.getCustomDataApplier()).getCustomData((Skull)blockState);
    }

    public static interface SkullTextureApplier
    extends CustomDataApplier {
        public boolean hasCustomData(@NotNull Skull var1);

        public String getCustomData(@NotNull Skull var1);
    }
}

