/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.customdata;

import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataApplier;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataType;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCustomData<T extends CustomDataApplier>
implements CustomData {
    @NotNull
    private final String name;
    @NotNull
    private final CustomDataType customDataType;
    @NotNull
    private final Info info;
    @Nullable
    private T customDataApplier;

    public AbstractCustomData(@NotNull String name, @NotNull CustomDataType customDataType, @NotNull Function<String, Info> infoFunction) {
        Validate.notNull((Object)name, (String)"Name can not be null");
        Validate.notNull((Object)((Object)customDataType), (String)"CustomDataType can not be null");
        Validate.notNull(infoFunction, (String)"InfoFunction can not be null");
        this.name = name;
        this.customDataType = customDataType;
        this.info = infoFunction.apply(this.getName());
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public CustomDataType getCustomDataType() {
        return this.customDataType;
    }

    @NotNull
    public T getCustomDataApplier() {
        if (this.customDataApplier == null) {
            this.customDataApplier = this.getCustomDataApplier0();
        }
        return this.customDataApplier;
    }

    @NotNull
    protected abstract T getCustomDataApplier0();

    @Override
    @NotNull
    public Info getInfo() {
        return this.info;
    }
}

