/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.customdata;

import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataApplier;
import de.derfrzocker.custom.ore.generator.impl.customdata.FileReadAbleCustomData;
import java.io.File;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.block.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBlockStateCustomData
extends FileReadAbleCustomData<BlockStateApplier> {
    public AbstractBlockStateCustomData(@NotNull Function<String, Info> infoFunction, @NotNull File fileFolder) {
        super("BLOCK_STATE", infoFunction, fileFolder);
    }

    @Override
    public boolean canApply(@NotNull OreConfig oreConfig) {
        return ((BlockStateApplier)this.getCustomDataApplier()).canApply(oreConfig);
    }

    @Override
    public boolean isValidCustomData0(@NotNull String customData, @NotNull OreConfig oreConfig) {
        return ((BlockStateApplier)this.getCustomDataApplier()).isValidCustomData(customData, oreConfig);
    }

    @Override
    public boolean hasCustomData(@NotNull BlockState blockState) {
        Validate.notNull((Object)blockState, (String)"BlockState can not be null");
        return ((BlockStateApplier)this.getCustomDataApplier()).hasCustomData(blockState);
    }

    @Override
    @NotNull
    public String getCustomData(@NotNull BlockState blockState) {
        Validate.isTrue((boolean)this.hasCustomData(blockState), (String)("The given BlockState '" + blockState.getType() + ", " + blockState.getLocation() + "' can not have the CustomData '" + this.getName() + "'"));
        return ((BlockStateApplier)this.getCustomDataApplier()).getCustomData(blockState);
    }

    public static interface BlockStateApplier
    extends CustomDataApplier {
        public boolean canApply(@NotNull OreConfig var1);

        public boolean isValidCustomData(@NotNull String var1, @NotNull OreConfig var2);

        public boolean hasCustomData(@NotNull BlockState var1);

        @NotNull
        public String getCustomData(@NotNull BlockState var1);
    }
}

